/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
$(document).ready(function() {

    $(".click-title").mouseenter( function(    e){
        e.preventDefault();
        this.style.cursor="pointer";
    });
    $(".click-title").mousedown( function(event){
        event.preventDefault();
    });

    // Ugly code while this script is shared among several pages
    try{
        refreshHitsPerSecond(true);
    } catch(e){}
    try{
        refreshResponseTimeOverTime(true);
    } catch(e){}
    try{
        refreshResponseTimePercentiles();
    } catch(e){}
});


var responseTimePercentilesInfos = {
        data: {"result": {"minY": 7.0, "minX": 0.0, "maxY": 74685.0, "series": [{"data": [[0.0, 7.0], [0.1, 28.0], [0.2, 28.0], [0.3, 29.0], [0.4, 29.0], [0.5, 30.0], [0.6, 30.0], [0.7, 30.0], [0.8, 31.0], [0.9, 31.0], [1.0, 31.0], [1.1, 32.0], [1.2, 32.0], [1.3, 32.0], [1.4, 32.0], [1.5, 33.0], [1.6, 33.0], [1.7, 33.0], [1.8, 33.0], [1.9, 34.0], [2.0, 34.0], [2.1, 34.0], [2.2, 35.0], [2.3, 35.0], [2.4, 35.0], [2.5, 36.0], [2.6, 36.0], [2.7, 36.0], [2.8, 36.0], [2.9, 37.0], [3.0, 37.0], [3.1, 37.0], [3.2, 38.0], [3.3, 38.0], [3.4, 38.0], [3.5, 38.0], [3.6, 39.0], [3.7, 39.0], [3.8, 39.0], [3.9, 39.0], [4.0, 39.0], [4.1, 40.0], [4.2, 40.0], [4.3, 40.0], [4.4, 40.0], [4.5, 41.0], [4.6, 41.0], [4.7, 41.0], [4.8, 42.0], [4.9, 42.0], [5.0, 42.0], [5.1, 42.0], [5.2, 43.0], [5.3, 43.0], [5.4, 43.0], [5.5, 43.0], [5.6, 44.0], [5.7, 44.0], [5.8, 44.0], [5.9, 44.0], [6.0, 44.0], [6.1, 45.0], [6.2, 45.0], [6.3, 45.0], [6.4, 45.0], [6.5, 46.0], [6.6, 46.0], [6.7, 46.0], [6.8, 46.0], [6.9, 47.0], [7.0, 47.0], [7.1, 47.0], [7.2, 47.0], [7.3, 48.0], [7.4, 48.0], [7.5, 48.0], [7.6, 48.0], [7.7, 49.0], [7.8, 49.0], [7.9, 49.0], [8.0, 50.0], [8.1, 50.0], [8.2, 50.0], [8.3, 50.0], [8.4, 51.0], [8.5, 51.0], [8.6, 51.0], [8.7, 52.0], [8.8, 52.0], [8.9, 52.0], [9.0, 52.0], [9.1, 53.0], [9.2, 53.0], [9.3, 54.0], [9.4, 54.0], [9.5, 54.0], [9.6, 55.0], [9.7, 55.0], [9.8, 55.0], [9.9, 56.0], [10.0, 56.0], [10.1, 56.0], [10.2, 57.0], [10.3, 57.0], [10.4, 58.0], [10.5, 58.0], [10.6, 58.0], [10.7, 59.0], [10.8, 59.0], [10.9, 59.0], [11.0, 60.0], [11.1, 60.0], [11.2, 61.0], [11.3, 61.0], [11.4, 62.0], [11.5, 62.0], [11.6, 62.0], [11.7, 63.0], [11.8, 63.0], [11.9, 64.0], [12.0, 65.0], [12.1, 65.0], [12.2, 66.0], [12.3, 67.0], [12.4, 67.0], [12.5, 68.0], [12.6, 68.0], [12.7, 70.0], [12.8, 70.0], [12.9, 71.0], [13.0, 71.0], [13.1, 72.0], [13.2, 73.0], [13.3, 74.0], [13.4, 75.0], [13.5, 76.0], [13.6, 77.0], [13.7, 78.0], [13.8, 79.0], [13.9, 80.0], [14.0, 81.0], [14.1, 82.0], [14.2, 83.0], [14.3, 85.0], [14.4, 86.0], [14.5, 88.0], [14.6, 89.0], [14.7, 90.0], [14.8, 92.0], [14.9, 92.0], [15.0, 94.0], [15.1, 97.0], [15.2, 99.0], [15.3, 100.0], [15.4, 102.0], [15.5, 104.0], [15.6, 107.0], [15.7, 109.0], [15.8, 112.0], [15.9, 115.0], [16.0, 119.0], [16.1, 122.0], [16.2, 127.0], [16.3, 132.0], [16.4, 142.0], [16.5, 146.0], [16.6, 151.0], [16.7, 158.0], [16.8, 168.0], [16.9, 176.0], [17.0, 185.0], [17.1, 194.0], [17.2, 205.0], [17.3, 214.0], [17.4, 224.0], [17.5, 235.0], [17.6, 248.0], [17.7, 263.0], [17.8, 278.0], [17.9, 297.0], [18.0, 309.0], [18.1, 325.0], [18.2, 344.0], [18.3, 363.0], [18.4, 384.0], [18.5, 403.0], [18.6, 423.0], [18.7, 446.0], [18.8, 467.0], [18.9, 493.0], [19.0, 511.0], [19.1, 535.0], [19.2, 564.0], [19.3, 584.0], [19.4, 616.0], [19.5, 639.0], [19.6, 665.0], [19.7, 684.0], [19.8, 711.0], [19.9, 748.0], [20.0, 775.0], [20.1, 804.0], [20.2, 821.0], [20.3, 843.0], [20.4, 861.0], [20.5, 889.0], [20.6, 916.0], [20.7, 947.0], [20.8, 966.0], [20.9, 985.0], [21.0, 1004.0], [21.1, 1036.0], [21.2, 1076.0], [21.3, 1104.0], [21.4, 1127.0], [21.5, 1151.0], [21.6, 1188.0], [21.7, 1223.0], [21.8, 1262.0], [21.9, 1284.0], [22.0, 1313.0], [22.1, 1344.0], [22.2, 1371.0], [22.3, 1400.0], [22.4, 1443.0], [22.5, 1469.0], [22.6, 1491.0], [22.7, 1519.0], [22.8, 1547.0], [22.9, 1577.0], [23.0, 1603.0], [23.1, 1631.0], [23.2, 1657.0], [23.3, 1697.0], [23.4, 1733.0], [23.5, 1788.0], [23.6, 1818.0], [23.7, 1855.0], [23.8, 1881.0], [23.9, 1910.0], [24.0, 1948.0], [24.1, 1981.0], [24.2, 2011.0], [24.3, 2038.0], [24.4, 2061.0], [24.5, 2091.0], [24.6, 2121.0], [24.7, 2151.0], [24.8, 2174.0], [24.9, 2203.0], [25.0, 2223.0], [25.1, 2256.0], [25.2, 2291.0], [25.3, 2323.0], [25.4, 2364.0], [25.5, 2392.0], [25.6, 2416.0], [25.7, 2449.0], [25.8, 2488.0], [25.9, 2518.0], [26.0, 2549.0], [26.1, 2579.0], [26.2, 2617.0], [26.3, 2643.0], [26.4, 2676.0], [26.5, 2715.0], [26.6, 2743.0], [26.7, 2763.0], [26.8, 2794.0], [26.9, 2829.0], [27.0, 2856.0], [27.1, 2881.0], [27.2, 2912.0], [27.3, 2950.0], [27.4, 2991.0], [27.5, 3015.0], [27.6, 3037.0], [27.7, 3075.0], [27.8, 3107.0], [27.9, 3131.0], [28.0, 3164.0], [28.1, 3200.0], [28.2, 3220.0], [28.3, 3262.0], [28.4, 3289.0], [28.5, 3326.0], [28.6, 3369.0], [28.7, 3396.0], [28.8, 3434.0], [28.9, 3467.0], [29.0, 3495.0], [29.1, 3526.0], [29.2, 3546.0], [29.3, 3577.0], [29.4, 3598.0], [29.5, 3637.0], [29.6, 3660.0], [29.7, 3691.0], [29.8, 3732.0], [29.9, 3758.0], [30.0, 3790.0], [30.1, 3810.0], [30.2, 3834.0], [30.3, 3861.0], [30.4, 3888.0], [30.5, 3919.0], [30.6, 3952.0], [30.7, 3979.0], [30.8, 4009.0], [30.9, 4037.0], [31.0, 4059.0], [31.1, 4092.0], [31.2, 4119.0], [31.3, 4144.0], [31.4, 4164.0], [31.5, 4190.0], [31.6, 4212.0], [31.7, 4245.0], [31.8, 4275.0], [31.9, 4296.0], [32.0, 4324.0], [32.1, 4354.0], [32.2, 4387.0], [32.3, 4406.0], [32.4, 4440.0], [32.5, 4460.0], [32.6, 4503.0], [32.7, 4527.0], [32.8, 4558.0], [32.9, 4592.0], [33.0, 4619.0], [33.1, 4658.0], [33.2, 4682.0], [33.3, 4702.0], [33.4, 4727.0], [33.5, 4747.0], [33.6, 4773.0], [33.7, 4802.0], [33.8, 4823.0], [33.9, 4840.0], [34.0, 4866.0], [34.1, 4889.0], [34.2, 4908.0], [34.3, 4928.0], [34.4, 4951.0], [34.5, 4984.0], [34.6, 5004.0], [34.7, 5029.0], [34.8, 5051.0], [34.9, 5073.0], [35.0, 5101.0], [35.1, 5122.0], [35.2, 5139.0], [35.3, 5160.0], [35.4, 5180.0], [35.5, 5201.0], [35.6, 5230.0], [35.7, 5249.0], [35.8, 5271.0], [35.9, 5292.0], [36.0, 5319.0], [36.1, 5341.0], [36.2, 5363.0], [36.3, 5387.0], [36.4, 5417.0], [36.5, 5440.0], [36.6, 5458.0], [36.7, 5475.0], [36.8, 5485.0], [36.9, 5507.0], [37.0, 5521.0], [37.1, 5550.0], [37.2, 5568.0], [37.3, 5588.0], [37.4, 5605.0], [37.5, 5614.0], [37.6, 5632.0], [37.7, 5650.0], [37.8, 5667.0], [37.9, 5688.0], [38.0, 5716.0], [38.1, 5734.0], [38.2, 5753.0], [38.3, 5768.0], [38.4, 5792.0], [38.5, 5810.0], [38.6, 5829.0], [38.7, 5844.0], [38.8, 5863.0], [38.9, 5882.0], [39.0, 5895.0], [39.1, 5920.0], [39.2, 5941.0], [39.3, 5963.0], [39.4, 5980.0], [39.5, 6000.0], [39.6, 6019.0], [39.7, 6028.0], [39.8, 6039.0], [39.9, 6050.0], [40.0, 6067.0], [40.1, 6086.0], [40.2, 6099.0], [40.3, 6114.0], [40.4, 6136.0], [40.5, 6154.0], [40.6, 6168.0], [40.7, 6183.0], [40.8, 6199.0], [40.9, 6214.0], [41.0, 6231.0], [41.1, 6245.0], [41.2, 6264.0], [41.3, 6276.0], [41.4, 6288.0], [41.5, 6307.0], [41.6, 6326.0], [41.7, 6340.0], [41.8, 6357.0], [41.9, 6373.0], [42.0, 6387.0], [42.1, 6404.0], [42.2, 6421.0], [42.3, 6435.0], [42.4, 6450.0], [42.5, 6467.0], [42.6, 6483.0], [42.7, 6500.0], [42.8, 6513.0], [42.9, 6527.0], [43.0, 6542.0], [43.1, 6559.0], [43.2, 6571.0], [43.3, 6586.0], [43.4, 6597.0], [43.5, 6607.0], [43.6, 6622.0], [43.7, 6633.0], [43.8, 6648.0], [43.9, 6664.0], [44.0, 6678.0], [44.1, 6689.0], [44.2, 6702.0], [44.3, 6714.0], [44.4, 6735.0], [44.5, 6749.0], [44.6, 6766.0], [44.7, 6783.0], [44.8, 6799.0], [44.9, 6810.0], [45.0, 6820.0], [45.1, 6832.0], [45.2, 6851.0], [45.3, 6868.0], [45.4, 6889.0], [45.5, 6904.0], [45.6, 6922.0], [45.7, 6940.0], [45.8, 6954.0], [45.9, 6965.0], [46.0, 6981.0], [46.1, 6996.0], [46.2, 7012.0], [46.3, 7026.0], [46.4, 7041.0], [46.5, 7053.0], [46.6, 7076.0], [46.7, 7091.0], [46.8, 7105.0], [46.9, 7121.0], [47.0, 7134.0], [47.1, 7150.0], [47.2, 7167.0], [47.3, 7184.0], [47.4, 7199.0], [47.5, 7215.0], [47.6, 7229.0], [47.7, 7243.0], [47.8, 7261.0], [47.9, 7275.0], [48.0, 7286.0], [48.1, 7300.0], [48.2, 7313.0], [48.3, 7322.0], [48.4, 7347.0], [48.5, 7361.0], [48.6, 7373.0], [48.7, 7388.0], [48.8, 7403.0], [48.9, 7414.0], [49.0, 7432.0], [49.1, 7446.0], [49.2, 7467.0], [49.3, 7482.0], [49.4, 7498.0], [49.5, 7513.0], [49.6, 7531.0], [49.7, 7552.0], [49.8, 7566.0], [49.9, 7581.0], [50.0, 7601.0], [50.1, 7618.0], [50.2, 7630.0], [50.3, 7645.0], [50.4, 7657.0], [50.5, 7673.0], [50.6, 7683.0], [50.7, 7700.0], [50.8, 7716.0], [50.9, 7731.0], [51.0, 7746.0], [51.1, 7768.0], [51.2, 7786.0], [51.3, 7806.0], [51.4, 7824.0], [51.5, 7841.0], [51.6, 7854.0], [51.7, 7870.0], [51.8, 7884.0], [51.9, 7899.0], [52.0, 7916.0], [52.1, 7928.0], [52.2, 7944.0], [52.3, 7955.0], [52.4, 7966.0], [52.5, 7983.0], [52.6, 7998.0], [52.7, 8014.0], [52.8, 8039.0], [52.9, 8056.0], [53.0, 8073.0], [53.1, 8094.0], [53.2, 8114.0], [53.3, 8126.0], [53.4, 8143.0], [53.5, 8165.0], [53.6, 8177.0], [53.7, 8190.0], [53.8, 8205.0], [53.9, 8222.0], [54.0, 8238.0], [54.1, 8253.0], [54.2, 8264.0], [54.3, 8280.0], [54.4, 8294.0], [54.5, 8309.0], [54.6, 8326.0], [54.7, 8341.0], [54.8, 8354.0], [54.9, 8369.0], [55.0, 8383.0], [55.1, 8400.0], [55.2, 8416.0], [55.3, 8429.0], [55.4, 8448.0], [55.5, 8470.0], [55.6, 8483.0], [55.7, 8497.0], [55.8, 8514.0], [55.9, 8531.0], [56.0, 8545.0], [56.1, 8560.0], [56.2, 8578.0], [56.3, 8591.0], [56.4, 8603.0], [56.5, 8622.0], [56.6, 8636.0], [56.7, 8649.0], [56.8, 8663.0], [56.9, 8680.0], [57.0, 8696.0], [57.1, 8709.0], [57.2, 8723.0], [57.3, 8736.0], [57.4, 8754.0], [57.5, 8769.0], [57.6, 8781.0], [57.7, 8796.0], [57.8, 8809.0], [57.9, 8823.0], [58.0, 8834.0], [58.1, 8848.0], [58.2, 8863.0], [58.3, 8879.0], [58.4, 8893.0], [58.5, 8910.0], [58.6, 8929.0], [58.7, 8940.0], [58.8, 8956.0], [58.9, 8971.0], [59.0, 8985.0], [59.1, 8999.0], [59.2, 9012.0], [59.3, 9024.0], [59.4, 9041.0], [59.5, 9056.0], [59.6, 9080.0], [59.7, 9094.0], [59.8, 9108.0], [59.9, 9120.0], [60.0, 9137.0], [60.1, 9156.0], [60.2, 9171.0], [60.3, 9184.0], [60.4, 9199.0], [60.5, 9211.0], [60.6, 9230.0], [60.7, 9244.0], [60.8, 9259.0], [60.9, 9272.0], [61.0, 9288.0], [61.1, 9297.0], [61.2, 9308.0], [61.3, 9326.0], [61.4, 9339.0], [61.5, 9352.0], [61.6, 9364.0], [61.7, 9382.0], [61.8, 9399.0], [61.9, 9409.0], [62.0, 9431.0], [62.1, 9447.0], [62.2, 9474.0], [62.3, 9488.0], [62.4, 9506.0], [62.5, 9520.0], [62.6, 9533.0], [62.7, 9548.0], [62.8, 9564.0], [62.9, 9578.0], [63.0, 9591.0], [63.1, 9602.0], [63.2, 9615.0], [63.3, 9631.0], [63.4, 9640.0], [63.5, 9648.0], [63.6, 9666.0], [63.7, 9678.0], [63.8, 9693.0], [63.9, 9710.0], [64.0, 9727.0], [64.1, 9744.0], [64.2, 9756.0], [64.3, 9776.0], [64.4, 9794.0], [64.5, 9811.0], [64.6, 9827.0], [64.7, 9842.0], [64.8, 9856.0], [64.9, 9870.0], [65.0, 9882.0], [65.1, 9899.0], [65.2, 9914.0], [65.3, 9931.0], [65.4, 9947.0], [65.5, 9964.0], [65.6, 9977.0], [65.7, 9993.0], [65.8, 10008.0], [65.9, 10021.0], [66.0, 10041.0], [66.1, 10053.0], [66.2, 10073.0], [66.3, 10090.0], [66.4, 10105.0], [66.5, 10124.0], [66.6, 10144.0], [66.7, 10159.0], [66.8, 10174.0], [66.9, 10188.0], [67.0, 10199.0], [67.1, 10216.0], [67.2, 10233.0], [67.3, 10251.0], [67.4, 10263.0], [67.5, 10283.0], [67.6, 10294.0], [67.7, 10307.0], [67.8, 10320.0], [67.9, 10336.0], [68.0, 10354.0], [68.1, 10366.0], [68.2, 10384.0], [68.3, 10398.0], [68.4, 10417.0], [68.5, 10426.0], [68.6, 10447.0], [68.7, 10463.0], [68.8, 10479.0], [68.9, 10498.0], [69.0, 10516.0], [69.1, 10529.0], [69.2, 10553.0], [69.3, 10564.0], [69.4, 10581.0], [69.5, 10604.0], [69.6, 10619.0], [69.7, 10643.0], [69.8, 10659.0], [69.9, 10687.0], [70.0, 10701.0], [70.1, 10720.0], [70.2, 10733.0], [70.3, 10753.0], [70.4, 10770.0], [70.5, 10787.0], [70.6, 10801.0], [70.7, 10820.0], [70.8, 10839.0], [70.9, 10861.0], [71.0, 10882.0], [71.1, 10904.0], [71.2, 10921.0], [71.3, 10939.0], [71.4, 10960.0], [71.5, 10984.0], [71.6, 11005.0], [71.7, 11023.0], [71.8, 11048.0], [71.9, 11073.0], [72.0, 11097.0], [72.1, 11118.0], [72.2, 11137.0], [72.3, 11151.0], [72.4, 11171.0], [72.5, 11186.0], [72.6, 11201.0], [72.7, 11225.0], [72.8, 11242.0], [72.9, 11262.0], [73.0, 11283.0], [73.1, 11308.0], [73.2, 11324.0], [73.3, 11338.0], [73.4, 11356.0], [73.5, 11384.0], [73.6, 11405.0], [73.7, 11431.0], [73.8, 11453.0], [73.9, 11468.0], [74.0, 11487.0], [74.1, 11507.0], [74.2, 11536.0], [74.3, 11558.0], [74.4, 11580.0], [74.5, 11600.0], [74.6, 11616.0], [74.7, 11631.0], [74.8, 11650.0], [74.9, 11674.0], [75.0, 11698.0], [75.1, 11719.0], [75.2, 11744.0], [75.3, 11760.0], [75.4, 11782.0], [75.5, 11804.0], [75.6, 11828.0], [75.7, 11844.0], [75.8, 11863.0], [75.9, 11891.0], [76.0, 11918.0], [76.1, 11940.0], [76.2, 11967.0], [76.3, 11991.0], [76.4, 12020.0], [76.5, 12042.0], [76.6, 12067.0], [76.7, 12084.0], [76.8, 12107.0], [76.9, 12130.0], [77.0, 12154.0], [77.1, 12181.0], [77.2, 12201.0], [77.3, 12227.0], [77.4, 12243.0], [77.5, 12256.0], [77.6, 12280.0], [77.7, 12310.0], [77.8, 12335.0], [77.9, 12362.0], [78.0, 12383.0], [78.1, 12402.0], [78.2, 12420.0], [78.3, 12451.0], [78.4, 12476.0], [78.5, 12497.0], [78.6, 12529.0], [78.7, 12562.0], [78.8, 12591.0], [78.9, 12614.0], [79.0, 12653.0], [79.1, 12687.0], [79.2, 12721.0], [79.3, 12752.0], [79.4, 12787.0], [79.5, 12816.0], [79.6, 12848.0], [79.7, 12876.0], [79.8, 12902.0], [79.9, 12934.0], [80.0, 12961.0], [80.1, 12989.0], [80.2, 13014.0], [80.3, 13048.0], [80.4, 13088.0], [80.5, 13117.0], [80.6, 13149.0], [80.7, 13180.0], [80.8, 13218.0], [80.9, 13258.0], [81.0, 13296.0], [81.1, 13334.0], [81.2, 13369.0], [81.3, 13403.0], [81.4, 13433.0], [81.5, 13476.0], [81.6, 13525.0], [81.7, 13551.0], [81.8, 13610.0], [81.9, 13652.0], [82.0, 13691.0], [82.1, 13731.0], [82.2, 13772.0], [82.3, 13804.0], [82.4, 13854.0], [82.5, 13890.0], [82.6, 13931.0], [82.7, 13967.0], [82.8, 14025.0], [82.9, 14066.0], [83.0, 14101.0], [83.1, 14135.0], [83.2, 14195.0], [83.3, 14247.0], [83.4, 14300.0], [83.5, 14362.0], [83.6, 14425.0], [83.7, 14492.0], [83.8, 14547.0], [83.9, 14622.0], [84.0, 14681.0], [84.1, 14772.0], [84.2, 14830.0], [84.3, 14928.0], [84.4, 15020.0], [84.5, 15122.0], [84.6, 15236.0], [84.7, 15369.0], [84.8, 15471.0], [84.9, 15555.0], [85.0, 15655.0], [85.1, 15753.0], [85.2, 15864.0], [85.3, 15976.0], [85.4, 16067.0], [85.5, 16170.0], [85.6, 16295.0], [85.7, 16374.0], [85.8, 16510.0], [85.9, 16616.0], [86.0, 16724.0], [86.1, 16847.0], [86.2, 16938.0], [86.3, 17040.0], [86.4, 17119.0], [86.5, 17201.0], [86.6, 17343.0], [86.7, 17451.0], [86.8, 17573.0], [86.9, 17707.0], [87.0, 17893.0], [87.1, 18040.0], [87.2, 18205.0], [87.3, 18364.0], [87.4, 18535.0], [87.5, 18730.0], [87.6, 18877.0], [87.7, 18986.0], [87.8, 19109.0], [87.9, 19263.0], [88.0, 19430.0], [88.1, 19592.0], [88.2, 19724.0], [88.3, 19860.0], [88.4, 19958.0], [88.5, 20076.0], [88.6, 20200.0], [88.7, 20302.0], [88.8, 20430.0], [88.9, 20588.0], [89.0, 20738.0], [89.1, 20868.0], [89.2, 20977.0], [89.3, 21121.0], [89.4, 21273.0], [89.5, 21402.0], [89.6, 21511.0], [89.7, 21614.0], [89.8, 21742.0], [89.9, 21924.0], [90.0, 22109.0], [90.1, 22255.0], [90.2, 22335.0], [90.3, 22460.0], [90.4, 22583.0], [90.5, 22675.0], [90.6, 22777.0], [90.7, 22895.0], [90.8, 23020.0], [90.9, 23132.0], [91.0, 23275.0], [91.1, 23410.0], [91.2, 23550.0], [91.3, 23666.0], [91.4, 23789.0], [91.5, 23892.0], [91.6, 24019.0], [91.7, 24206.0], [91.8, 24369.0], [91.9, 24507.0], [92.0, 24670.0], [92.1, 24812.0], [92.2, 25080.0], [92.3, 25184.0], [92.4, 25348.0], [92.5, 25434.0], [92.6, 25575.0], [92.7, 25696.0], [92.8, 25831.0], [92.9, 25938.0], [93.0, 26028.0], [93.1, 26151.0], [93.2, 26294.0], [93.3, 26421.0], [93.4, 26521.0], [93.5, 26626.0], [93.6, 26729.0], [93.7, 26865.0], [93.8, 26964.0], [93.9, 27089.0], [94.0, 27230.0], [94.1, 27367.0], [94.2, 27499.0], [94.3, 27687.0], [94.4, 27858.0], [94.5, 27997.0], [94.6, 28144.0], [94.7, 28440.0], [94.8, 28604.0], [94.9, 28804.0], [95.0, 28992.0], [95.1, 29154.0], [95.2, 29279.0], [95.3, 29492.0], [95.4, 29701.0], [95.5, 29812.0], [95.6, 29975.0], [95.7, 30106.0], [95.8, 30232.0], [95.9, 30406.0], [96.0, 30580.0], [96.1, 30786.0], [96.2, 30882.0], [96.3, 31043.0], [96.4, 31207.0], [96.5, 31314.0], [96.6, 31499.0], [96.7, 31626.0], [96.8, 31758.0], [96.9, 31900.0], [97.0, 32098.0], [97.1, 32245.0], [97.2, 32425.0], [97.3, 32602.0], [97.4, 32875.0], [97.5, 33228.0], [97.6, 33776.0], [97.7, 34403.0], [97.8, 35015.0], [97.9, 35733.0], [98.0, 36287.0], [98.1, 36938.0], [98.2, 37653.0], [98.3, 38417.0], [98.4, 39011.0], [98.5, 39766.0], [98.6, 40334.0], [98.7, 41129.0], [98.8, 42000.0], [98.9, 42850.0], [99.0, 43744.0], [99.1, 44773.0], [99.2, 45530.0], [99.3, 47005.0], [99.4, 48440.0], [99.5, 50322.0], [99.6, 51915.0], [99.7, 53299.0], [99.8, 55144.0], [99.9, 56750.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 100.0, "title": "Response Time Percentiles"}},
        getOptions: function() {
            return {
                series: {
                    points: { show: false }
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentiles'
                },
                xaxis: {
                    tickDecimals: 1,
                    axisLabel: "Percentiles",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Percentile value in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : %x.2 percentile was %y ms"
                },
                selection: { mode: "xy" },
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentiles"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesPercentiles"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesPercentiles"), dataset, prepareOverviewOptions(options));
        }
};

/**
 * @param elementId Id of element where we display message
 */
function setEmptyGraph(elementId) {
    $(function() {
        $(elementId).text("No graph series with filter="+seriesFilter);
    });
}

// Response times percentiles
function refreshResponseTimePercentiles() {
    var infos = responseTimePercentilesInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimePercentiles");
        return;
    }
    if (isGraph($("#flotResponseTimesPercentiles"))){
        infos.createGraph();
    } else {
        var choiceContainer = $("#choicesResponseTimePercentiles");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesPercentiles", "#overviewResponseTimesPercentiles");
        $('#bodyResponseTimePercentiles .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 0.0, "maxY": 3890.0, "series": [{"data": [[0.0, 3890.0], [100.0, 482.0], [33700.0, 9.0], [34500.0, 7.0], [32900.0, 11.0], [36100.0, 2.0], [35300.0, 5.0], [36900.0, 5.0], [37700.0, 3.0], [38500.0, 2.0], [39300.0, 3.0], [40100.0, 2.0], [40900.0, 5.0], [41700.0, 4.0], [42500.0, 4.0], [43300.0, 6.0], [44100.0, 3.0], [44900.0, 7.0], [46500.0, 1.0], [47300.0, 3.0], [48900.0, 5.0], [48100.0, 2.0], [50500.0, 1.0], [49700.0, 3.0], [200.0, 196.0], [52900.0, 1.0], [51300.0, 1.0], [52100.0, 6.0], [53700.0, 3.0], [54500.0, 3.0], [56900.0, 2.0], [55300.0, 3.0], [59300.0, 1.0], [300.0, 140.0], [400.0, 111.0], [500.0, 111.0], [600.0, 104.0], [700.0, 80.0], [800.0, 119.0], [900.0, 110.0], [1000.0, 79.0], [1100.0, 90.0], [1200.0, 80.0], [1300.0, 85.0], [1400.0, 88.0], [1500.0, 90.0], [1600.0, 81.0], [1700.0, 62.0], [1800.0, 82.0], [1900.0, 72.0], [2000.0, 96.0], [2100.0, 92.0], [2200.0, 88.0], [2300.0, 70.0], [2400.0, 83.0], [2500.0, 82.0], [2600.0, 76.0], [2800.0, 86.0], [2700.0, 89.0], [2900.0, 74.0], [3000.0, 87.0], [3100.0, 82.0], [3200.0, 83.0], [3300.0, 72.0], [3400.0, 79.0], [3500.0, 100.0], [3700.0, 84.0], [3600.0, 78.0], [3800.0, 96.0], [3900.0, 86.0], [4000.0, 95.0], [4100.0, 102.0], [4200.0, 95.0], [4300.0, 91.0], [4600.0, 90.0], [4400.0, 84.0], [4500.0, 87.0], [4800.0, 114.0], [4700.0, 104.0], [4900.0, 109.0], [5100.0, 129.0], [5000.0, 106.0], [5300.0, 107.0], [5200.0, 109.0], [5500.0, 128.0], [5600.0, 144.0], [5400.0, 132.0], [5800.0, 145.0], [5700.0, 132.0], [6000.0, 179.0], [5900.0, 122.0], [6100.0, 153.0], [6300.0, 154.0], [6200.0, 169.0], [6500.0, 188.0], [6600.0, 192.0], [6400.0, 157.0], [6900.0, 163.0], [6700.0, 159.0], [6800.0, 172.0], [7000.0, 167.0], [7100.0, 161.0], [7300.0, 174.0], [7200.0, 176.0], [7400.0, 164.0], [7600.0, 181.0], [7500.0, 144.0], [7700.0, 145.0], [7800.0, 162.0], [7900.0, 180.0], [8000.0, 135.0], [8100.0, 159.0], [8600.0, 170.0], [8200.0, 169.0], [8400.0, 157.0], [8800.0, 184.0], [9000.0, 163.0], [9200.0, 184.0], [9600.0, 196.0], [9400.0, 142.0], [9800.0, 174.0], [10000.0, 158.0], [10200.0, 164.0], [10600.0, 131.0], [10400.0, 155.0], [10800.0, 128.0], [11000.0, 113.0], [11200.0, 122.0], [11600.0, 133.0], [11400.0, 126.0], [12200.0, 120.0], [11800.0, 115.0], [12000.0, 107.0], [12400.0, 108.0], [12600.0, 85.0], [13000.0, 69.0], [13200.0, 67.0], [12800.0, 85.0], [13400.0, 70.0], [13800.0, 61.0], [13600.0, 58.0], [14200.0, 46.0], [14000.0, 61.0], [14800.0, 27.0], [14600.0, 39.0], [14400.0, 45.0], [15200.0, 23.0], [15000.0, 24.0], [15600.0, 27.0], [15800.0, 18.0], [15400.0, 28.0], [16000.0, 27.0], [16200.0, 17.0], [16800.0, 21.0], [16400.0, 14.0], [17200.0, 15.0], [17600.0, 20.0], [18000.0, 19.0], [18400.0, 12.0], [18800.0, 21.0], [19200.0, 18.0], [19600.0, 15.0], [20400.0, 19.0], [20000.0, 21.0], [21200.0, 21.0], [20800.0, 13.0], [21600.0, 20.0], [22400.0, 18.0], [22000.0, 14.0], [22800.0, 23.0], [23200.0, 19.0], [24400.0, 19.0], [23600.0, 19.0], [24000.0, 8.0], [24800.0, 15.0], [25200.0, 15.0], [25600.0, 17.0], [26000.0, 25.0], [26400.0, 23.0], [27200.0, 21.0], [26800.0, 19.0], [27600.0, 11.0], [28400.0, 12.0], [28000.0, 21.0], [29600.0, 13.0], [28800.0, 17.0], [29200.0, 19.0], [30000.0, 21.0], [30400.0, 16.0], [31200.0, 20.0], [30800.0, 21.0], [31600.0, 22.0], [32400.0, 18.0], [32000.0, 12.0], [34400.0, 5.0], [33600.0, 11.0], [32800.0, 9.0], [35200.0, 3.0], [36800.0, 6.0], [36000.0, 9.0], [37600.0, 7.0], [38400.0, 6.0], [39200.0, 4.0], [40000.0, 6.0], [40800.0, 1.0], [42400.0, 3.0], [41600.0, 4.0], [43200.0, 5.0], [44800.0, 6.0], [44000.0, 2.0], [46400.0, 2.0], [45600.0, 2.0], [47200.0, 2.0], [48000.0, 1.0], [49600.0, 1.0], [50400.0, 3.0], [52800.0, 1.0], [51200.0, 2.0], [52000.0, 1.0], [53600.0, 2.0], [56800.0, 1.0], [56000.0, 1.0], [59200.0, 1.0], [60000.0, 2.0], [33900.0, 6.0], [34700.0, 2.0], [33100.0, 2.0], [35500.0, 4.0], [36300.0, 7.0], [38700.0, 4.0], [37100.0, 4.0], [37900.0, 2.0], [39500.0, 5.0], [40300.0, 6.0], [41100.0, 2.0], [41900.0, 3.0], [42700.0, 4.0], [44300.0, 3.0], [45900.0, 3.0], [45100.0, 4.0], [46700.0, 3.0], [47500.0, 3.0], [50700.0, 1.0], [52300.0, 1.0], [53100.0, 1.0], [53900.0, 3.0], [57100.0, 4.0], [55500.0, 1.0], [58700.0, 1.0], [16500.0, 27.0], [16900.0, 29.0], [17300.0, 26.0], [17700.0, 14.0], [18100.0, 17.0], [18500.0, 17.0], [18900.0, 22.0], [19300.0, 16.0], [19700.0, 23.0], [20100.0, 20.0], [21300.0, 15.0], [20900.0, 25.0], [20500.0, 15.0], [21700.0, 25.0], [22100.0, 15.0], [22500.0, 26.0], [22900.0, 17.0], [23300.0, 18.0], [24100.0, 17.0], [23700.0, 23.0], [24500.0, 15.0], [24900.0, 10.0], [25300.0, 23.0], [26100.0, 17.0], [26500.0, 28.0], [25700.0, 20.0], [26900.0, 21.0], [27300.0, 19.0], [28500.0, 15.0], [27700.0, 15.0], [28100.0, 9.0], [28900.0, 11.0], [29300.0, 13.0], [29700.0, 21.0], [30100.0, 18.0], [30500.0, 14.0], [30900.0, 17.0], [31700.0, 21.0], [31300.0, 14.0], [32100.0, 15.0], [32500.0, 14.0], [34600.0, 3.0], [33000.0, 7.0], [33800.0, 1.0], [36200.0, 6.0], [35400.0, 2.0], [37800.0, 4.0], [38600.0, 3.0], [37000.0, 3.0], [40200.0, 5.0], [39400.0, 4.0], [41000.0, 3.0], [41800.0, 5.0], [42600.0, 2.0], [45000.0, 3.0], [43400.0, 1.0], [46600.0, 1.0], [45800.0, 2.0], [47400.0, 2.0], [48200.0, 3.0], [49000.0, 1.0], [49800.0, 1.0], [50600.0, 1.0], [53000.0, 2.0], [52200.0, 1.0], [51400.0, 1.0], [54600.0, 1.0], [53800.0, 1.0], [56200.0, 2.0], [55400.0, 1.0], [58600.0, 1.0], [34100.0, 1.0], [33300.0, 2.0], [35700.0, 3.0], [34900.0, 6.0], [36500.0, 2.0], [37300.0, 2.0], [38100.0, 3.0], [38900.0, 3.0], [39700.0, 3.0], [40500.0, 2.0], [41300.0, 2.0], [42100.0, 3.0], [43700.0, 4.0], [44500.0, 2.0], [46900.0, 1.0], [46100.0, 1.0], [45300.0, 1.0], [49300.0, 3.0], [50100.0, 1.0], [52500.0, 2.0], [51700.0, 1.0], [54100.0, 3.0], [54900.0, 1.0], [53300.0, 1.0], [55700.0, 4.0], [57300.0, 2.0], [56500.0, 2.0], [59700.0, 1.0], [74600.0, 1.0], [8500.0, 167.0], [8700.0, 176.0], [8300.0, 169.0], [8900.0, 168.0], [9100.0, 168.0], [9300.0, 173.0], [9700.0, 147.0], [9500.0, 180.0], [9900.0, 162.0], [10100.0, 164.0], [10700.0, 154.0], [10300.0, 169.0], [10500.0, 140.0], [11100.0, 149.0], [10900.0, 122.0], [11300.0, 127.0], [11700.0, 119.0], [11500.0, 109.0], [12100.0, 110.0], [11900.0, 103.0], [12700.0, 77.0], [12300.0, 110.0], [12500.0, 76.0], [12900.0, 94.0], [13100.0, 80.0], [13300.0, 72.0], [13700.0, 71.0], [13500.0, 56.0], [13900.0, 57.0], [14100.0, 57.0], [14300.0, 37.0], [14500.0, 39.0], [14700.0, 33.0], [14900.0, 30.0], [15100.0, 26.0], [15300.0, 17.0], [15700.0, 28.0], [15500.0, 24.0], [16100.0, 24.0], [15900.0, 30.0], [16300.0, 30.0], [17000.0, 25.0], [17400.0, 23.0], [16600.0, 24.0], [18200.0, 13.0], [17800.0, 15.0], [19000.0, 16.0], [19400.0, 14.0], [18600.0, 9.0], [20200.0, 24.0], [19800.0, 21.0], [21400.0, 22.0], [21000.0, 16.0], [20600.0, 22.0], [22200.0, 25.0], [21800.0, 7.0], [23000.0, 26.0], [22600.0, 22.0], [23400.0, 17.0], [24200.0, 21.0], [23800.0, 22.0], [24600.0, 15.0], [25400.0, 23.0], [25000.0, 10.0], [26200.0, 20.0], [25800.0, 21.0], [26600.0, 21.0], [27000.0, 21.0], [27400.0, 17.0], [27800.0, 17.0], [28200.0, 12.0], [28600.0, 13.0], [29000.0, 13.0], [29400.0, 9.0], [30200.0, 15.0], [30600.0, 13.0], [29800.0, 18.0], [31400.0, 19.0], [31000.0, 12.0], [32600.0, 11.0], [31800.0, 18.0], [32200.0, 18.0], [34800.0, 3.0], [34000.0, 3.0], [33200.0, 6.0], [36400.0, 4.0], [35600.0, 1.0], [38800.0, 8.0], [37200.0, 1.0], [38000.0, 1.0], [39600.0, 3.0], [40400.0, 4.0], [41200.0, 3.0], [42000.0, 3.0], [42800.0, 1.0], [43600.0, 4.0], [44400.0, 4.0], [46800.0, 3.0], [46000.0, 2.0], [45200.0, 2.0], [47600.0, 3.0], [48400.0, 1.0], [50000.0, 2.0], [49200.0, 2.0], [50800.0, 2.0], [51600.0, 3.0], [52400.0, 1.0], [53200.0, 2.0], [54800.0, 1.0], [55600.0, 2.0], [57200.0, 1.0], [58000.0, 2.0], [58800.0, 1.0], [34300.0, 4.0], [33500.0, 1.0], [35100.0, 8.0], [35900.0, 3.0], [36700.0, 2.0], [37500.0, 7.0], [38300.0, 6.0], [39100.0, 1.0], [39900.0, 5.0], [40700.0, 1.0], [41500.0, 2.0], [42300.0, 2.0], [43900.0, 4.0], [43100.0, 4.0], [44700.0, 3.0], [45500.0, 3.0], [47100.0, 1.0], [46300.0, 1.0], [47900.0, 4.0], [50300.0, 3.0], [51100.0, 2.0], [49500.0, 3.0], [51900.0, 3.0], [52700.0, 2.0], [54300.0, 1.0], [55100.0, 1.0], [53500.0, 1.0], [56700.0, 1.0], [55900.0, 1.0], [57500.0, 2.0], [16700.0, 25.0], [17100.0, 32.0], [17500.0, 15.0], [18300.0, 22.0], [17900.0, 14.0], [18700.0, 15.0], [19100.0, 19.0], [19900.0, 24.0], [19500.0, 19.0], [20300.0, 21.0], [20700.0, 19.0], [21500.0, 24.0], [21100.0, 19.0], [22300.0, 27.0], [21900.0, 14.0], [23100.0, 19.0], [22700.0, 25.0], [23500.0, 24.0], [23900.0, 22.0], [24300.0, 13.0], [25100.0, 21.0], [25500.0, 23.0], [24700.0, 19.0], [26300.0, 18.0], [25900.0, 27.0], [26700.0, 25.0], [27100.0, 18.0], [27500.0, 16.0], [27900.0, 19.0], [28300.0, 5.0], [29500.0, 11.0], [28700.0, 12.0], [29100.0, 22.0], [29900.0, 15.0], [30300.0, 19.0], [30700.0, 15.0], [31500.0, 14.0], [31100.0, 19.0], [31900.0, 14.0], [32300.0, 11.0], [32700.0, 8.0], [34200.0, 6.0], [33400.0, 3.0], [35800.0, 5.0], [36600.0, 2.0], [35000.0, 1.0], [37400.0, 1.0], [38200.0, 3.0], [39800.0, 5.0], [39000.0, 3.0], [40600.0, 5.0], [42200.0, 4.0], [41400.0, 1.0], [43000.0, 3.0], [44600.0, 2.0], [43800.0, 1.0], [45400.0, 1.0], [46200.0, 1.0], [47000.0, 2.0], [48600.0, 1.0], [49400.0, 1.0], [51000.0, 2.0], [51800.0, 2.0], [52600.0, 3.0], [55000.0, 1.0], [54200.0, 2.0], [53400.0, 1.0], [55800.0, 6.0], [56600.0, 1.0], [59000.0, 1.0], [61400.0, 1.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 100, "maxX": 74600.0, "title": "Response Time Distribution"}},
        getOptions: function() {
            var granularity = this.data.result.granularity;
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    barWidth: this.data.result.granularity
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " responses for " + label + " were between " + xval + " and " + (xval + granularity) + " ms";
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimeDistribution"), prepareData(data.result.series, $("#choicesResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshResponseTimeDistribution() {
    var infos = responseTimeDistributionInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeDistribution");
        return;
    }
    if (isGraph($("#flotResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var syntheticResponseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 0.0, "ticks": [[0, "Requests having \nresponse time <= 500ms"], [1, "Requests having \nresponse time > 500ms and <= 1,500ms"], [2, "Requests having \nresponse time > 1,500ms"], [3, "Requests in error"]], "maxY": 19702.0, "series": [{"data": [[0.0, 4823.0]], "color": "#9ACD32", "isOverall": false, "label": "Requests having \nresponse time <= 500ms", "isController": false}, {"data": [[1.0, 944.0]], "color": "yellow", "isOverall": false, "label": "Requests having \nresponse time > 500ms and <= 1,500ms", "isController": false}, {"data": [[2.0, 19702.0]], "color": "orange", "isOverall": false, "label": "Requests having \nresponse time > 1,500ms", "isController": false}, {"data": [[3.0, 1.0]], "color": "#FF6347", "isOverall": false, "label": "Requests in error", "isController": false}], "supportsControllersDiscrimination": false, "maxX": 3.0, "title": "Synthetic Response Times Distribution"}},
        getOptions: function() {
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendSyntheticResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times ranges",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                    tickLength:0,
                    min:-0.5,
                    max:3.5
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    align: "center",
                    barWidth: 0.25,
                    fill:.75
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " " + label;
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            options.xaxis.ticks = data.result.ticks;
            $.plot($("#flotSyntheticResponseTimeDistribution"), prepareData(data.result.series, $("#choicesSyntheticResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshSyntheticResponseTimeDistribution() {
    var infos = syntheticResponseTimeDistributionInfos;
    prepareSeries(infos.data, true);
    if (isGraph($("#flotSyntheticResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerSyntheticResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var activeThreadsOverTimeInfos = {
        data: {"result": {"minY": 502.9715302491102, "minX": 1.698213E12, "maxY": 881.5398138572925, "series": [{"data": [[1.69821324E12, 854.4570946981295], [1.69821306E12, 782.8914529914522], [1.69821336E12, 881.5398138572925], [1.69821318E12, 684.585601935875], [1.698213E12, 528.1280276816611], [1.6982133E12, 502.9715302491102], [1.69821312E12, 731.9048295454561]], "isOverall": false, "label": "jp@gc - Ultimate Thread Group", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821336E12, "title": "Active Threads Over Time"}},
        getOptions: function() {
            return {
                series: {
                    stack: true,
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 6,
                    show: true,
                    container: '#legendActiveThreadsOverTime'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                selection: {
                    mode: 'xy'
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : At %x there were %y active threads"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesActiveThreadsOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotActiveThreadsOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewActiveThreadsOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Active Threads Over Time
function refreshActiveThreadsOverTime(fixTimestamps) {
    var infos = activeThreadsOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotActiveThreadsOverTime"))) {
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesActiveThreadsOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotActiveThreadsOverTime", "#overviewActiveThreadsOverTime");
        $('#footerActiveThreadsOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var timeVsThreadsInfos = {
        data: {"result": {"minY": 925.3333333333334, "minX": 1.0, "maxY": 21758.600000000006, "series": [{"data": [[2.0, 11675.5], [3.0, 5556.666666666667], [4.0, 9418.0], [5.0, 12437.6], [6.0, 3691.4], [7.0, 11281.25], [8.0, 2222.25], [9.0, 13725.0], [10.0, 7649.714285714285], [11.0, 4334.4], [12.0, 7393.333333333333], [13.0, 5078.6], [14.0, 2963.2], [15.0, 5711.5], [16.0, 13421.333333333336], [17.0, 4441.428571428572], [18.0, 9092.57142857143], [19.0, 6874.142857142858], [20.0, 8588.6], [21.0, 7902.0], [22.0, 8392.75], [23.0, 4096.666666666667], [24.0, 8926.25], [25.0, 1670.6999999999998], [26.0, 11979.6], [27.0, 7869.857142857143], [28.0, 5737.125], [29.0, 4113.2], [30.0, 14253.833333333332], [31.0, 925.3333333333334], [33.0, 10197.714285714286], [32.0, 7907.75], [34.0, 5577.625], [35.0, 3270.3999999999996], [36.0, 7268.727272727273], [37.0, 1483.4], [39.0, 3815.9166666666665], [38.0, 12936.714285714284], [40.0, 8095.428571428572], [41.0, 3543.6666666666665], [43.0, 6082.5], [42.0, 10304.5], [44.0, 5348.272727272726], [45.0, 3781.285714285714], [47.0, 1979.2], [46.0, 11242.833333333332], [49.0, 4045.142857142857], [48.0, 5797.428571428572], [50.0, 4511.0], [51.0, 5157.0], [53.0, 8269.416666666666], [52.0, 5382.125], [55.0, 6073.333333333332], [54.0, 12872.25], [57.0, 5620.555555555556], [56.0, 4104.125], [59.0, 10299.666666666666], [58.0, 2651.444444444444], [60.0, 6637.0], [61.0, 4401.444444444445], [63.0, 6438.142857142857], [62.0, 5814.749999999999], [64.0, 7992.0], [67.0, 7058.0], [65.0, 3959.357142857143], [66.0, 5318.0], [68.0, 7153.0], [70.0, 6250.249999999999], [71.0, 5694.0], [69.0, 6295.499999999999], [73.0, 7787.625], [75.0, 7145.0], [74.0, 7466.142857142857], [72.0, 11814.25], [77.0, 7182.285714285714], [78.0, 8124.714285714286], [79.0, 8952.5], [76.0, 8096.2], [80.0, 6172.125], [81.0, 3786.1111111111113], [83.0, 6538.692307692307], [82.0, 7718.666666666667], [84.0, 6190.555555555556], [86.0, 4145.0], [87.0, 4762.545454545454], [85.0, 6441.0], [89.0, 5367.090909090909], [90.0, 6073.6], [91.0, 4174.428571428572], [88.0, 6219.888888888889], [95.0, 4474.5], [94.0, 5971.636363636364], [93.0, 9069.5], [92.0, 4931.75], [96.0, 6484.500000000001], [99.0, 8208.666666666666], [97.0, 9308.8], [98.0, 4454.625], [100.0, 6837.888888888889], [103.0, 6171.4000000000015], [102.0, 10238.25], [101.0, 6916.4], [106.0, 6881.625], [107.0, 6652.333333333333], [105.0, 6761.555555555557], [104.0, 9175.8], [109.0, 9565.333333333332], [111.0, 8421.57142857143], [110.0, 8262.666666666666], [108.0, 9666.0], [113.0, 8049.125], [114.0, 5446.428571428572], [115.0, 6902.555555555556], [112.0, 9011.0], [116.0, 7251.0], [117.0, 8953.846153846154], [119.0, 11311.4], [118.0, 7685.875], [120.0, 6083.666666666666], [121.0, 5910.0], [123.0, 5830.800000000001], [122.0, 5772.583333333332], [124.0, 8900.5], [126.0, 12479.142857142859], [127.0, 4401.555555555555], [125.0, 4159.6], [131.0, 4008.125], [133.0, 9568.0], [134.0, 5539.916666666667], [135.0, 7496.875000000001], [130.0, 6228.000000000001], [129.0, 6072.181818181818], [128.0, 6909.625], [132.0, 2833.1111111111113], [137.0, 7517.625], [139.0, 4391.642857142857], [143.0, 8955.777777777777], [141.0, 6207.0], [140.0, 10283.8], [138.0, 10998.0], [136.0, 9109.5], [142.0, 4785.833333333333], [144.0, 9506.0], [146.0, 10617.42857142857], [147.0, 4825.125000000001], [150.0, 12571.272727272728], [151.0, 4778.444444444444], [145.0, 3857.833333333333], [148.0, 3091.2222222222226], [149.0, 4008.571428571428], [153.0, 4364.25], [156.0, 6148.272727272727], [157.0, 4539.923076923076], [158.0, 6931.625], [155.0, 9024.57142857143], [154.0, 7121.416666666668], [152.0, 9518.125], [159.0, 3281.666666666666], [160.0, 8841.3], [163.0, 6017.333333333333], [164.0, 7856.888888888889], [166.0, 13770.5], [167.0, 16249.0], [162.0, 8642.444444444445], [161.0, 5651.857142857142], [165.0, 3407.0], [168.0, 6043.500000000001], [169.0, 8417.0], [170.0, 8521.142857142857], [174.0, 13071.75], [175.0, 8146.0], [173.0, 6498.142857142857], [172.0, 9778.499999999998], [171.0, 9631.4], [176.0, 4537.083333333334], [177.0, 8688.8], [178.0, 9231.166666666666], [180.0, 6613.000000000001], [183.0, 8587.111111111111], [182.0, 8298.857142857143], [181.0, 5801.999999999999], [179.0, 9252.666666666666], [187.0, 7584.200000000001], [191.0, 11892.785714285716], [190.0, 9153.583333333334], [189.0, 8177.0714285714275], [188.0, 11685.111111111111], [186.0, 8847.099999999999], [185.0, 10055.2], [184.0, 5594.857142857143], [194.0, 7891.785714285714], [196.0, 14032.0], [197.0, 9602.727272727274], [199.0, 8395.5], [198.0, 17958.2], [195.0, 10219.0], [193.0, 7110.5714285714275], [192.0, 12238.285714285716], [200.0, 13857.214285714284], [201.0, 10243.90909090909], [203.0, 9635.5], [207.0, 13588.6], [206.0, 13729.083333333334], [205.0, 12208.5], [204.0, 13983.714285714286], [202.0, 5494.5], [209.0, 7501.230769230771], [210.0, 5128.833333333335], [211.0, 14017.92857142857], [213.0, 12601.499999999998], [214.0, 6673.599999999999], [215.0, 8935.5], [212.0, 9658.823529411764], [208.0, 6575.384615384616], [216.0, 13318.066666666666], [217.0, 9748.714285714288], [218.0, 12084.6], [219.0, 14974.333333333334], [223.0, 8993.5], [222.0, 8538.357142857143], [221.0, 12604.25], [220.0, 8680.727272727272], [224.0, 7552.307692307692], [228.0, 12237.500000000004], [230.0, 5846.692307692308], [231.0, 7571.0666666666675], [229.0, 8638.416666666668], [227.0, 11412.652173913042], [226.0, 10279.894736842105], [225.0, 10682.777777777777], [232.0, 13713.15789473684], [236.0, 8493.545454545456], [237.0, 4702.541666666666], [239.0, 21758.600000000006], [238.0, 7910.714285714285], [235.0, 12127.222222222223], [234.0, 8966.384615384613], [233.0, 11587.76470588235], [240.0, 10147.0], [241.0, 12818.500000000002], [243.0, 8602.583333333334], [244.0, 7763.083333333333], [246.0, 4895.580645161292], [247.0, 8050.047619047618], [245.0, 15301.272727272728], [242.0, 14552.099999999999], [248.0, 13525.407407407403], [249.0, 14495.0], [250.0, 9981.21052631579], [251.0, 10912.615384615387], [253.0, 11929.214285714286], [254.0, 9830.833333333334], [252.0, 8294.000000000002], [255.0, 6339.909090909091], [256.0, 10952.4], [260.0, 7021.857142857142], [261.0, 10170.7], [263.0, 8760.842105263158], [262.0, 7913.357142857142], [264.0, 9560.875], [265.0, 12314.12], [266.0, 18387.5], [267.0, 6223.125], [270.0, 6225.785714285715], [269.0, 13107.699999999999], [268.0, 12492.235294117647], [259.0, 14221.555555555555], [258.0, 8669.130434782608], [257.0, 11199.384615384615], [271.0, 11863.333333333338], [286.0, 9151.4], [274.0, 8316.533333333335], [277.0, 7738.687500000001], [276.0, 9230.416666666668], [279.0, 10266.904761904765], [278.0, 14030.142857142857], [273.0, 12154.857142857143], [272.0, 10413.857142857143], [280.0, 13290.0], [283.0, 11195.916666666668], [284.0, 7769.11111111111], [275.0, 12239.699999999999], [287.0, 7627.200000000001], [285.0, 9121.57142857143], [282.0, 15876.199999999999], [281.0, 13244.0], [300.0, 6945.599999999999], [296.0, 12442.346153846154], [294.0, 12262.529411764706], [292.0, 7978.333333333333], [293.0, 8119.999999999999], [297.0, 17066.40909090909], [299.0, 10456.125], [298.0, 13510.499999999998], [303.0, 7710.642857142858], [302.0, 15085.000000000002], [301.0, 10260.888888888889], [295.0, 10762.888888888887], [289.0, 14416.285714285716], [288.0, 9501.785714285716], [291.0, 12308.086956521738], [290.0, 4318.8823529411775], [306.0, 11098.647058823532], [304.0, 11508.555555555553], [305.0, 13839.423076923078], [311.0, 9414.230769230768], [310.0, 10100.4], [309.0, 10198.22222222222], [308.0, 19427.222222222223], [307.0, 13299.03921568628], [316.0, 10816.75], [312.0, 8955.454545454544], [313.0, 10261.125], [314.0, 9012.937500000002], [317.0, 10982.809523809525], [319.0, 11308.25], [318.0, 9357.599999999999], [315.0, 11560.090909090908], [334.0, 9317.083333333334], [320.0, 10852.18181818182], [326.0, 12720.0], [325.0, 9482.999999999998], [324.0, 12508.416666666664], [327.0, 7910.411764705882], [329.0, 13593.0], [330.0, 10790.222222222223], [331.0, 6223.636363636363], [333.0, 10619.0], [335.0, 17811.714285714286], [332.0, 18471.0], [323.0, 10396.0], [322.0, 12444.7], [321.0, 9878.769230769232], [328.0, 7035.500000000001], [336.0, 9194.400000000001], [337.0, 8431.823529411762], [339.0, 12458.363636363636], [348.0, 11149.0], [338.0, 6459.153846153846], [340.0, 7690.736842105263], [341.0, 7561.846153846153], [343.0, 14082.428571428572], [342.0, 6399.727272727273], [344.0, 10159.230769230771], [346.0, 8341.090909090908], [345.0, 10921.999999999998], [347.0, 14635.900000000001], [349.0, 9487.199999999999], [350.0, 8346.285714285714], [351.0, 6391.615384615386], [364.0, 14897.437500000002], [354.0, 9678.76923076923], [353.0, 12213.333333333334], [359.0, 13343.157894736842], [352.0, 7340.888888888888], [355.0, 11806.500000000002], [357.0, 7916.533333333333], [356.0, 8080.461538461539], [358.0, 9468.0], [360.0, 9176.4], [363.0, 7754.88888888889], [362.0, 7846.666666666667], [361.0, 8397.307692307693], [366.0, 18926.833333333332], [365.0, 15510.785714285716], [367.0, 5335.75], [380.0, 7916.562499999999], [371.0, 8275.5], [375.0, 9501.933333333334], [369.0, 9193.812500000002], [368.0, 9327.666666666668], [370.0, 9261.07142857143], [373.0, 11210.64705882353], [372.0, 9110.76923076923], [374.0, 8885.5], [376.0, 10947.111111111111], [383.0, 14223.07142857143], [382.0, 7046.555555555556], [381.0, 10575.875], [379.0, 14156.909090909092], [378.0, 6616.833333333335], [377.0, 6933.6], [396.0, 12241.222222222219], [384.0, 9643.461538461539], [387.0, 6793.0666666666675], [386.0, 14234.600000000002], [385.0, 9354.909090909092], [388.0, 6524.923076923077], [389.0, 8119.363636363636], [390.0, 6535.578947368422], [391.0, 14241.468749999998], [393.0, 17664.913043478264], [394.0, 10225.214285714283], [397.0, 8178.285714285715], [392.0, 16058.542857142855], [399.0, 8046.749999999998], [398.0, 11164.0], [395.0, 6241.11111111111], [400.0, 13710.416666666668], [403.0, 12298.315789473685], [412.0, 6415.285714285714], [402.0, 8966.64705882353], [401.0, 9675.642857142855], [404.0, 8969.857142857141], [405.0, 6908.055555555556], [406.0, 11203.039999999997], [407.0, 11042.071428571428], [409.0, 9114.42857142857], [410.0, 4053.3000000000006], [411.0, 6043.333333333334], [413.0, 8426.454545454544], [414.0, 7627.000000000001], [415.0, 6664.363636363636], [408.0, 6717.9375], [417.0, 10862.142857142857], [423.0, 4788.230769230769], [416.0, 3738.4210526315787], [427.0, 5360.714285714285], [429.0, 2820.9411764705883], [430.0, 2193.8333333333335], [431.0, 4614.25], [428.0, 4555.0], [418.0, 5744.285714285715], [419.0, 2862.375], [426.0, 4849.294117647059], [424.0, 3696.6153846153843], [425.0, 5601.181818181818], [422.0, 6221.666666666667], [421.0, 6614.066666666666], [420.0, 3165.5], [446.0, 4508.214285714285], [434.0, 6757.5], [436.0, 7594.052631578947], [438.0, 6840.9444444444425], [439.0, 4127.785714285714], [433.0, 6626.545454545456], [432.0, 8098.2142857142835], [437.0, 7766.2307692307695], [440.0, 5253.481481481483], [441.0, 5461.0], [443.0, 5436.357142857144], [442.0, 7029.727272727272], [444.0, 6338.294117647058], [435.0, 6801.0], [447.0, 6951.388888888889], [445.0, 3733.785714285714], [460.0, 7269.75], [449.0, 3743.133333333333], [451.0, 7688.315789473684], [450.0, 3778.5], [453.0, 8739.95652173913], [452.0, 5483.809523809524], [454.0, 3649.5789473684213], [455.0, 4202.590909090909], [448.0, 4544.405405405404], [456.0, 4732.307692307693], [457.0, 5466.380952380951], [459.0, 8074.142857142859], [458.0, 5888.083333333333], [463.0, 5816.518518518517], [462.0, 5598.499999999999], [461.0, 3396.7857142857147], [476.0, 3384.5714285714284], [464.0, 3231.125], [467.0, 3666.785714285714], [466.0, 7219.7692307692305], [465.0, 7144.333333333332], [470.0, 5814.559999999999], [468.0, 4279.111111111111], [469.0, 8053.666666666667], [471.0, 5815.235294117646], [473.0, 4586.062500000002], [472.0, 4244.210526315789], [477.0, 4677.384615384615], [478.0, 3865.75], [479.0, 10205.999999999998], [475.0, 6003.526315789474], [474.0, 6126.090909090908], [493.0, 4321.666666666667], [480.0, 9461.53846153846], [483.0, 4630.133333333333], [492.0, 4122.181818181818], [482.0, 5689.909090909091], [481.0, 4511.727272727272], [484.0, 7411.583333333334], [487.0, 5382.4000000000015], [486.0, 2457.785714285714], [485.0, 7346.692307692307], [488.0, 5405.421052631579], [490.0, 9632.894736842103], [489.0, 2331.4285714285716], [491.0, 7714.249999999999], [495.0, 6047.846153846154], [494.0, 2775.5384615384614], [511.0, 6541.538461538462], [499.0, 3347.6666666666665], [508.0, 4472.4], [498.0, 6800.266666666666], [497.0, 3379.4285714285716], [496.0, 6113.625], [506.0, 5671.166666666666], [507.0, 4035.9230769230776], [509.0, 9877.384615384615], [510.0, 7755.15], [505.0, 6700.333333333333], [504.0, 6074.388888888889], [503.0, 7194.166666666666], [502.0, 6062.083333333334], [501.0, 5912.133333333333], [500.0, 4326.181818181818], [537.0, 7768.8125], [524.0, 5280.071428571428], [514.0, 4552.823529411764], [517.0, 6236.526315789474], [516.0, 5408.999999999999], [515.0, 8297.600000000002], [518.0, 9591.076923076924], [536.0, 8381.214285714286], [519.0, 3957.0], [539.0, 4126.2], [538.0, 6333.700000000001], [540.0, 4932.5625], [543.0, 7781.375], [528.0, 4542.3125], [542.0, 21652.666666666668], [541.0, 5455.076923076924], [529.0, 5280.833333333332], [530.0, 7136.4000000000015], [532.0, 8393.6], [533.0, 2637.6249999999995], [531.0, 3646.833333333333], [534.0, 5579.4000000000015], [535.0, 8183.941176470588], [520.0, 3521.5882352941176], [521.0, 5326.666666666667], [522.0, 5670.0], [523.0, 7857.187499999998], [525.0, 5796.818181818182], [526.0, 8520.444444444443], [527.0, 5208.105263157895], [513.0, 6070.2], [512.0, 5985.444444444445], [569.0, 5791.363636363636], [547.0, 8021.583333333334], [544.0, 7085.8], [559.0, 4269.05], [546.0, 11413.76923076923], [545.0, 5639.285714285714], [551.0, 6141.235294117647], [550.0, 6188.133333333334], [549.0, 6647.35294117647], [548.0, 5675.6875], [568.0, 5571.277777777777], [557.0, 9866.214285714284], [556.0, 3098.1875], [555.0, 5769.133333333333], [554.0, 9152.909090909092], [553.0, 6848.400000000001], [552.0, 9846.777777777777], [558.0, 5973.117647058824], [560.0, 7361.375], [561.0, 4198.789473684211], [562.0, 5837.909090909091], [565.0, 9880.999999999998], [564.0, 3167.2727272727275], [563.0, 3994.9999999999995], [566.0, 5155.263157894737], [567.0, 6006.849999999999], [570.0, 9508.833333333332], [571.0, 5996.777777777778], [573.0, 11395.875], [572.0, 7089.083333333335], [574.0, 7841.625], [575.0, 6287.307692307693], [600.0, 7693.615384615385], [579.0, 10066.714285714286], [577.0, 9186.35294117647], [576.0, 6810.153846153847], [578.0, 7114.272727272727], [580.0, 9162.900000000001], [581.0, 5511.882352941177], [583.0, 8117.599999999999], [582.0, 6270.307692307692], [603.0, 5900.375000000001], [602.0, 6110.2], [601.0, 6730.0], [604.0, 8347.833333333334], [606.0, 6758.705882352943], [605.0, 6514.384615384616], [607.0, 7677.125], [592.0, 7656.0], [584.0, 7088.357142857144], [586.0, 6501.583333333333], [585.0, 4914.333333333333], [588.0, 9677.636363636364], [587.0, 7245.7], [589.0, 9718.777777777777], [591.0, 5677.937499999999], [590.0, 5783.071428571428], [593.0, 6473.090909090908], [594.0, 7833.714285714286], [595.0, 5394.124999999999], [596.0, 7121.916666666667], [598.0, 4886.125], [597.0, 7393.3], [599.0, 9053.916666666666], [611.0, 5185.428571428571], [610.0, 8382.428571428572], [609.0, 6000.0], [608.0, 7667.214285714286], [614.0, 5569.619047619046], [613.0, 9733.1], [612.0, 6951.230769230769], [615.0, 7119.272727272728], [632.0, 6288.0714285714275], [633.0, 7792.846153846153], [634.0, 5784.700000000001], [635.0, 9232.25], [636.0, 5612.764705882354], [637.0, 4985.12121212121], [638.0, 5262.0952380952385], [639.0, 5632.066666666667], [616.0, 6832.352941176469], [617.0, 7236.357142857142], [619.0, 6768.500000000001], [618.0, 6890.357142857142], [622.0, 7277.826086956522], [621.0, 3299.7499999999995], [620.0, 8223.857142857143], [623.0, 7097.846153846153], [624.0, 7116.294117647058], [627.0, 9700.76923076923], [626.0, 7544.0], [625.0, 7246.9375], [628.0, 5070.315789473685], [630.0, 5451.615384615385], [631.0, 5987.36], [629.0, 9474.75], [647.0, 6526.818181818181], [641.0, 13024.076923076924], [640.0, 6624.588235294118], [654.0, 6968.055555555557], [655.0, 7327.95], [643.0, 5614.666666666668], [642.0, 7460.785714285714], [644.0, 6823.814814814815], [646.0, 7145.687500000001], [645.0, 6492.2380952380945], [657.0, 9810.0], [659.0, 7827.333333333332], [658.0, 5701.9473684210525], [671.0, 6663.428571428571], [656.0, 7637.476190476191], [667.0, 8180.045454545457], [669.0, 9504.411764705883], [668.0, 7934.874999999999], [670.0, 7144.6], [664.0, 5255.8], [665.0, 7540.842105263159], [666.0, 5394.2], [660.0, 8455.388888888889], [663.0, 9692.23076923077], [662.0, 5665.222222222223], [661.0, 7570.124999999999], [649.0, 6093.538461538461], [648.0, 6674.5], [650.0, 4953.571428571428], [651.0, 5504.083333333334], [652.0, 9408.333333333332], [653.0, 8865.076923076922], [700.0, 6371.222222222223], [676.0, 9696.5], [673.0, 9856.444444444443], [672.0, 8474.0], [675.0, 9680.066666666668], [674.0, 3315.3], [677.0, 8021.312499999998], [678.0, 10775.9], [679.0, 8814.222222222223], [696.0, 6863.08695652174], [697.0, 7525.571428571428], [699.0, 5661.571428571428], [698.0, 7679.545454545456], [701.0, 7492.624999999999], [703.0, 8494.3], [688.0, 7358.071428571428], [690.0, 8912.699999999999], [689.0, 6495.869565217392], [692.0, 8718.7], [691.0, 6617.538461538462], [702.0, 8788.647058823532], [680.0, 9716.230769230768], [681.0, 9388.000000000002], [682.0, 6349.59090909091], [686.0, 9078.066666666668], [685.0, 7670.833333333334], [684.0, 6853.0], [683.0, 8021.176470588235], [687.0, 8992.863636363638], [693.0, 6634.409090909092], [694.0, 7432.315789473682], [695.0, 7924.133333333332], [730.0, 6680.090909090908], [706.0, 7284.192307692307], [704.0, 8180.4], [705.0, 5939.0], [707.0, 8799.050000000001], [708.0, 5261.857142857142], [709.0, 9592.875], [710.0, 6136.818181818182], [711.0, 7258.090909090909], [729.0, 12801.0], [728.0, 4843.200000000001], [731.0, 9626.714285714286], [732.0, 6844.222222222223], [733.0, 9167.07142857143], [735.0, 8208.117647058825], [734.0, 8077.90909090909], [720.0, 9274.923076923076], [723.0, 12122.461538461537], [722.0, 8961.75], [721.0, 8490.500000000002], [724.0, 7428.25], [726.0, 8498.999999999998], [725.0, 6914.538461538462], [727.0, 10961.23076923077], [713.0, 7067.133333333332], [712.0, 5892.894736842106], [714.0, 6215.599999999999], [716.0, 6116.909090909091], [715.0, 7802.199999999999], [718.0, 7933.812500000001], [717.0, 6112.772727272728], [719.0, 8616.8], [760.0, 9184.142857142859], [737.0, 9138.133333333333], [736.0, 5195.153846153847], [751.0, 7812.111111111112], [750.0, 12088.125], [740.0, 8338.384615384615], [739.0, 7701.166666666667], [738.0, 7869.666666666664], [741.0, 9758.150000000001], [743.0, 16228.749999999998], [742.0, 7826.7], [763.0, 10051.47619047619], [762.0, 7426.545454545455], [761.0, 8885.750000000002], [764.0, 7825.849999999999], [766.0, 9464.1], [765.0, 7204.75], [767.0, 7841.75], [752.0, 10267.545454545454], [757.0, 9458.785714285712], [756.0, 10406.0], [755.0, 9984.0], [754.0, 6697.42857142857], [753.0, 13285.0], [759.0, 7284.3], [758.0, 7856.714285714287], [744.0, 9465.312500000002], [745.0, 9096.846153846154], [746.0, 7872.5625], [747.0, 10246.2], [748.0, 7394.500000000001], [749.0, 10533.400000000001], [773.0, 10512.541666666666], [769.0, 10022.384615384617], [768.0, 7888.785714285715], [770.0, 14356.153846153848], [772.0, 8781.3], [771.0, 8956.818181818184], [774.0, 9015.238095238095], [792.0, 6413.166666666667], [775.0, 10299.363636363636], [793.0, 7873.409090909092], [794.0, 6192.727272727272], [796.0, 7797.117647058823], [795.0, 7992.705882352941], [797.0, 9030.789473684212], [799.0, 8220.8], [798.0, 7480.722222222222], [776.0, 8033.217391304348], [777.0, 9340.95652173913], [781.0, 9214.57142857143], [780.0, 7831.333333333333], [779.0, 11371.083333333334], [778.0, 6785.133333333334], [782.0, 7750.157894736842], [783.0, 8485.57142857143], [784.0, 8138.187500000001], [786.0, 8227.4], [785.0, 9416.428571428572], [787.0, 7538.400000000001], [789.0, 7921.545454545455], [788.0, 7508.470588235295], [790.0, 8695.384615384615], [791.0, 7071.0], [807.0, 7291.789473684211], [801.0, 8880.75], [800.0, 8582.470588235296], [803.0, 6864.464285714284], [802.0, 9836.5], [804.0, 9003.70588235294], [806.0, 10375.037037037035], [805.0, 8001.000000000001], [816.0, 8612.739130434786], [831.0, 7758.263157894736], [826.0, 9754.62962962963], [825.0, 7857.0], [824.0, 7875.687499999999], [827.0, 8232.294117647058], [829.0, 5639.384615384616], [828.0, 9834.0], [830.0, 6695.047619047618], [817.0, 6922.214285714285], [819.0, 8640.727272727274], [818.0, 11573.11111111111], [820.0, 6802.1], [821.0, 8964.423076923074], [823.0, 7522.666666666667], [822.0, 8135.1111111111095], [809.0, 7967.879999999999], [810.0, 6003.461538461538], [808.0, 6909.749999999999], [811.0, 9183.04761904762], [813.0, 6987.65217391304], [812.0, 9333.61111111111], [814.0, 7982.250000000001], [815.0, 9659.884615384613], [836.0, 7337.071428571429], [834.0, 12817.8125], [833.0, 7420.05], [832.0, 9681.05], [835.0, 9863.818181818184], [837.0, 8581.65], [838.0, 5697.65], [839.0, 7381.500000000002], [840.0, 6863.513513513513], [841.0, 10939.75], [842.0, 10423.875000000002], [844.0, 7824.642857142858], [843.0, 8552.066666666666], [846.0, 7419.874999999999], [845.0, 9716.888888888889], [847.0, 9412.285714285714], [850.0, 8747.346153846152], [849.0, 7085.130434782607], [848.0, 10204.999999999998], [860.0, 7405.722222222221], [862.0, 8530.230769230768], [861.0, 8524.07142857143], [863.0, 7267.285714285714], [857.0, 8936.277777777777], [856.0, 9715.285714285714], [858.0, 9538.25], [859.0, 9889.105263157895], [851.0, 8541.65], [852.0, 9625.600000000002], [853.0, 6093.794117647059], [854.0, 8992.2], [855.0, 7381.2307692307695], [866.0, 7922.299999999998], [864.0, 9465.550000000001], [865.0, 9688.153846153844], [867.0, 7874.882352941176], [868.0, 10539.5], [869.0, 8077.368421052631], [874.0, 10071.05882352941], [872.0, 6778.555555555556], [873.0, 7656.904761904762], [875.0, 9159.499999999998], [876.0, 6526.227272727273], [877.0, 8406.666666666666], [878.0, 9425.312500000002], [879.0, 8085.0], [883.0, 8748.852941176472], [882.0, 7933.999999999999], [880.0, 11367.571428571428], [881.0, 14313.454545454548], [894.0, 9917.526315789473], [895.0, 10366.833333333332], [890.0, 14037.352941176472], [888.0, 9288.0], [889.0, 9356.785714285716], [871.0, 8065.083333333334], [870.0, 11101.941176470587], [892.0, 8124.25], [891.0, 10705.076923076924], [893.0, 12004.272727272728], [884.0, 8556.42857142857], [886.0, 9472.312500000002], [885.0, 13160.083333333334], [887.0, 6910.208333333333], [899.0, 10760.684210526317], [897.0, 7825.045454545455], [898.0, 7752.099999999999], [900.0, 10839.125], [902.0, 11108.526315789475], [901.0, 9480.307692307691], [903.0, 10331.266666666668], [904.0, 12488.153846153848], [906.0, 10548.777777777777], [907.0, 9824.923076923076], [905.0, 9539.785714285714], [909.0, 8643.23076923077], [908.0, 9135.72222222222], [910.0, 9827.33333333333], [911.0, 10770.5], [896.0, 10342.099999999999], [913.0, 7698.631578947369], [927.0, 9604.038461538461], [912.0, 9156.149999999998], [923.0, 6918.240000000001], [922.0, 7385.4], [921.0, 10408.0], [920.0, 8485.866666666667], [924.0, 8976.846153846154], [925.0, 6397.8], [926.0, 9800.758620689656], [914.0, 11334.166666666666], [916.0, 9089.300000000001], [915.0, 9566.099999999999], [917.0, 7573.3125], [919.0, 11204.68], [918.0, 13563.578947368424], [953.0, 10545.533333333336], [941.0, 7688.833333333333], [929.0, 7359.7619047619055], [928.0, 9387.25], [930.0, 9347.807692307691], [931.0, 8612.10344827586], [934.0, 8260.451612903224], [932.0, 9886.428571428572], [933.0, 12228.166666666668], [952.0, 8616.972972972972], [935.0, 9404.666666666666], [954.0, 8301.064516129034], [955.0, 10110.999999999998], [956.0, 12210.449999999997], [957.0, 11518.857142857141], [959.0, 8648.060606060608], [958.0, 10650.480000000001], [937.0, 7782.857142857144], [936.0, 7992.708333333334], [938.0, 9183.78260869565], [939.0, 10528.777777777777], [940.0, 6846.128205128204], [943.0, 9902.849999999999], [942.0, 7483.190476190476], [944.0, 5535.652173913044], [946.0, 8648.615384615383], [945.0, 8750.962962962964], [947.0, 11657.500000000002], [948.0, 8897.357142857143], [949.0, 10343.77272727273], [950.0, 9748.812499999998], [951.0, 10361.294117647058], [966.0, 9716.187500000004], [960.0, 8707.035714285716], [962.0, 10554.428571428569], [961.0, 15497.928571428574], [963.0, 11883.864864864861], [964.0, 11411.04347826087], [965.0, 8888.677966101694], [967.0, 9687.65517241379], [985.0, 10329.607142857147], [984.0, 16924.481481481478], [987.0, 11749.249999999995], [986.0, 13792.599999999999], [989.0, 20237.5], [988.0, 10960.87878787879], [969.0, 8150.131578947366], [968.0, 9394.571428571428], [970.0, 12149.083333333332], [972.0, 11625.999999999998], [971.0, 8646.066666666668], [974.0, 8116.789473684209], [973.0, 9226.35135135135], [975.0, 7075.461538461539], [976.0, 9606.5], [980.0, 8228.620689655172], [981.0, 7985.466666666667], [979.0, 14091.687500000002], [978.0, 12642.136363636364], [977.0, 10231.551724137931], [983.0, 8085.952380952381], [982.0, 11108.29166666667], [990.0, 8516.510204081638], [991.0, 14860.525000000009], [994.0, 10047.045977011496], [993.0, 10150.906250000002], [996.0, 15023.803278688525], [997.0, 9539.238095238095], [999.0, 11505.628571428573], [1000.0, 10235.148999615243], [998.0, 16593.825], [995.0, 10087.926829268292], [992.0, 10224.756756756758], [1.0, 12149.333333333332]], "isOverall": false, "label": "HTTP Request", "isController": false}, {"data": [[753.0078916372152, 9190.15351393798]], "isOverall": false, "label": "HTTP Request-Aggregated", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 1000.0, "title": "Time VS Threads"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: { noColumns: 2,show: true, container: '#legendTimeVsThreads' },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s: At %x.2 active threads, Average response time was %y.2 ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesTimeVsThreads"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotTimesVsThreads"), dataset, options);
            // setup overview
            $.plot($("#overviewTimesVsThreads"), dataset, prepareOverviewOptions(options));
        }
};

// Time vs threads
function refreshTimeVsThreads(){
    var infos = timeVsThreadsInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTimeVsThreads");
        return;
    }
    if(isGraph($("#flotTimesVsThreads"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTimeVsThreads");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTimesVsThreads", "#overviewTimesVsThreads");
        $('#footerTimeVsThreads .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var bytesThroughputOverTimeInfos = {
        data : {"result": {"minY": 2080.8, "minX": 1.698213E12, "maxY": 16967.6, "series": [{"data": [[1.69821324E12, 15662.4], [1.69821306E12, 5618.35], [1.69821336E12, 11604.0], [1.69821318E12, 7934.4], [1.698213E12, 2080.8], [1.6982133E12, 8092.8], [1.69821312E12, 10137.6]], "isOverall": false, "label": "Bytes received per second", "isController": false}, {"data": [[1.69821324E12, 16967.6], [1.69821306E12, 6084.0], [1.69821336E12, 12571.0], [1.69821318E12, 8595.6], [1.698213E12, 2254.2], [1.6982133E12, 8767.2], [1.69821312E12, 10982.4]], "isOverall": false, "label": "Bytes sent per second", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821336E12, "title": "Bytes Throughput Over Time"}},
        getOptions : function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity) ,
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Bytes / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendBytesThroughputOverTime'
                },
                selection: {
                    mode: "xy"
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y"
                }
            };
        },
        createGraph : function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesBytesThroughputOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotBytesThroughputOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewBytesThroughputOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Bytes throughput Over Time
function refreshBytesThroughputOverTime(fixTimestamps) {
    var infos = bytesThroughputOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotBytesThroughputOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesBytesThroughputOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotBytesThroughputOverTime", "#overviewBytesThroughputOverTime");
        $('#footerBytesThroughputOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimesOverTimeInfos = {
        data: {"result": {"minY": 5518.571174377201, "minX": 1.698213E12, "maxY": 22796.235897435854, "series": [{"data": [[1.69821324E12, 7721.524670548579], [1.69821306E12, 22796.235897435854], [1.69821336E12, 8755.972078593584], [1.69821318E12, 10887.304900181474], [1.698213E12, 7564.67358708189], [1.6982133E12, 5518.571174377201], [1.69821312E12, 6355.018702651501]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821336E12, "title": "Response Time Over Time"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average response time was %y ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Times Over Time
function refreshResponseTimeOverTime(fixTimestamps) {
    var infos = responseTimesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimesOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesOverTime", "#overviewResponseTimesOverTime");
        $('#footerResponseTimesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var latenciesOverTimeInfos = {
        data: {"result": {"minY": 5518.529952550411, "minX": 1.698213E12, "maxY": 22796.185042735047, "series": [{"data": [[1.69821324E12, 7721.490193073848], [1.69821306E12, 22796.185042735047], [1.69821336E12, 8755.938779731112], [1.69821318E12, 10887.272534785197], [1.698213E12, 7564.577854671266], [1.6982133E12, 5518.529952550411], [1.69821312E12, 6354.978456439399]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821336E12, "title": "Latencies Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response latencies in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendLatenciesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average latency was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesLatenciesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotLatenciesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewLatenciesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Latencies Over Time
function refreshLatenciesOverTime(fixTimestamps) {
    var infos = latenciesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyLatenciesOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotLatenciesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesLatenciesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotLatenciesOverTime", "#overviewLatenciesOverTime");
        $('#footerLatenciesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var connectTimeOverTimeInfos = {
        data: {"result": {"minY": 1.9973112719751778, "minX": 1.698213E12, "maxY": 4.723183391003458, "series": [{"data": [[1.69821324E12, 2.0427520686484986], [1.69821306E12, 2.7081196581196556], [1.69821336E12, 1.9973112719751778], [1.69821318E12, 2.2217180883242564], [1.698213E12, 4.723183391003458], [1.6982133E12, 2.0394424673784095], [1.69821312E12, 2.70288825757576]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821336E12, "title": "Connect Time Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getConnectTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average Connect Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendConnectTimeOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average connect time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesConnectTimeOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotConnectTimeOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewConnectTimeOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Connect Time Over Time
function refreshConnectTimeOverTime(fixTimestamps) {
    var infos = connectTimeOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyConnectTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotConnectTimeOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesConnectTimeOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotConnectTimeOverTime", "#overviewConnectTimeOverTime");
        $('#footerConnectTimeOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var responseTimePercentilesOverTimeInfos = {
        data: {"result": {"minY": 23.0, "minX": 1.698213E12, "maxY": 74685.0, "series": [{"data": [[1.69821324E12, 74685.0], [1.69821306E12, 44891.0], [1.69821336E12, 20156.0], [1.69821318E12, 59728.0], [1.698213E12, 18895.0], [1.6982133E12, 29643.0], [1.69821312E12, 27172.0]], "isOverall": false, "label": "Max", "isController": false}, {"data": [[1.69821324E12, 21465.6], [1.69821306E12, 34301.0], [1.69821336E12, 12958.0], [1.69821318E12, 31962.50000000001], [1.698213E12, 13087.6], [1.6982133E12, 13990.500000000024], [1.69821312E12, 13601.0]], "isOverall": false, "label": "90th percentile", "isController": false}, {"data": [[1.69821324E12, 29126.23999999996], [1.69821306E12, 42125.2], [1.69821336E12, 14815.960000000005], [1.69821318E12, 55084.519999999975], [1.698213E12, 16818.239999999994], [1.6982133E12, 25266.51], [1.69821312E12, 19582.25]], "isOverall": false, "label": "99th percentile", "isController": false}, {"data": [[1.69821324E12, 25567.3], [1.69821306E12, 38417.0], [1.69821336E12, 13639.2], [1.69821318E12, 46410.14999999996], [1.698213E12, 14325.199999999997], [1.6982133E12, 20926.5], [1.69821312E12, 15698.75]], "isOverall": false, "label": "95th percentile", "isController": false}, {"data": [[1.69821324E12, 27.0], [1.69821306E12, 30.0], [1.69821336E12, 26.0], [1.69821318E12, 24.0], [1.698213E12, 174.0], [1.6982133E12, 26.0], [1.69821312E12, 23.0]], "isOverall": false, "label": "Min", "isController": false}, {"data": [[1.69821324E12, 6507.0], [1.69821306E12, 23956.0], [1.69821336E12, 10131.0], [1.69821318E12, 7361.0], [1.698213E12, 7351.0], [1.6982133E12, 4332.5], [1.69821312E12, 6196.0]], "isOverall": false, "label": "Median", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821336E12, "title": "Response Time Percentiles Over Time (successful requests only)"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Response Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentilesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Response time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentilesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimePercentilesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimePercentilesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Time Percentiles Over Time
function refreshResponseTimePercentilesOverTime(fixTimestamps) {
    var infos = responseTimePercentilesOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimePercentilesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimePercentilesOverTime", "#overviewResponseTimePercentilesOverTime");
        $('#footerResponseTimePercentilesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var responseTimeVsRequestInfos = {
    data: {"result": {"minY": 7.0, "minX": 1.0, "maxY": 47484.0, "series": [{"data": [[2.0, 37330.5], [3.0, 13639.0], [5.0, 28092.5], [7.0, 44040.0], [8.0, 43884.0], [9.0, 36043.0], [10.0, 42240.5], [12.0, 27919.0], [14.0, 23562.5], [17.0, 22702.0], [18.0, 7514.5], [19.0, 748.0], [20.0, 47484.0], [22.0, 5664.0], [23.0, 4382.5], [24.0, 14864.0], [25.0, 22038.0], [26.0, 18755.5], [27.0, 19558.5], [28.0, 12698.5], [29.0, 6966.0], [30.0, 13096.5], [31.0, 11404.0], [32.0, 16750.0], [33.0, 17471.0], [34.0, 5581.0], [35.0, 12293.0], [36.0, 9325.5], [37.0, 32088.0], [39.0, 12550.0], [38.0, 28764.5], [41.0, 9255.0], [40.0, 15511.0], [42.0, 30669.0], [43.0, 30647.0], [45.0, 28604.0], [47.0, 21330.5], [48.0, 14835.0], [49.0, 17086.5], [51.0, 11712.5], [50.0, 10451.5], [52.0, 31808.5], [55.0, 30398.0], [56.0, 25583.0], [57.0, 473.0], [61.0, 1297.5], [60.0, 1635.5], [63.0, 3030.0], [62.0, 9057.5], [65.0, 15706.0], [67.0, 3193.0], [64.0, 3081.0], [66.0, 12208.0], [69.0, 29712.0], [68.0, 729.0], [71.0, 7224.0], [70.0, 8568.5], [73.0, 3823.0], [74.0, 8876.5], [75.0, 8492.0], [72.0, 4075.0], [78.0, 2175.0], [79.0, 1762.0], [76.0, 2179.5], [80.0, 1798.0], [82.0, 6007.5], [81.0, 712.0], [83.0, 2506.0], [84.0, 6407.5], [87.0, 2879.5], [86.0, 9678.5], [88.0, 10741.5], [90.0, 4972.0], [89.0, 6299.5], [91.0, 9974.0], [92.0, 7293.5], [94.0, 7227.0], [95.0, 5140.0], [93.0, 7103.5], [99.0, 8570.0], [98.0, 8289.0], [97.0, 4743.0], [96.0, 6253.0], [102.0, 10133.5], [103.0, 6650.0], [100.0, 10309.5], [101.0, 9532.5], [104.0, 5956.0], [105.0, 5400.5], [106.0, 9671.5], [107.0, 9729.0], [111.0, 6286.5], [110.0, 9848.5], [109.0, 7878.0], [112.0, 6664.0], [115.0, 9672.0], [114.0, 9035.5], [116.0, 9671.5], [118.0, 2427.5], [119.0, 6680.0], [117.0, 7733.0], [123.0, 9030.0], [120.0, 6937.0], [121.0, 10527.0], [124.0, 6511.5], [127.0, 11130.0], [131.0, 3470.0], [128.0, 7948.0], [133.0, 8926.0], [134.0, 2001.0], [135.0, 8173.5], [132.0, 9198.0], [142.0, 6097.5], [140.0, 8861.0], [137.0, 11467.0], [141.0, 7150.0], [138.0, 7949.5], [136.0, 8322.0], [143.0, 7860.0], [147.0, 6804.0], [149.0, 490.0], [148.0, 4085.0], [145.0, 7866.0], [146.0, 10790.0], [156.0, 7708.5], [159.0, 7604.5], [152.0, 10644.5], [153.0, 11394.0], [165.0, 11557.0], [163.0, 7705.0], [172.0, 6256.5], [185.0, 11069.0], [199.0, 9540.0], [212.0, 4972.5], [217.0, 4529.0], [232.0, 2131.5], [245.0, 5591.0], [293.0, 6831.0], [1.0, 33245.5]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[49.0, 7.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 293.0, "title": "Response Time Vs Request"}},
    getOptions: function() {
        return {
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Response Time in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: {
                noColumns: 2,
                show: true,
                container: '#legendResponseTimeVsRequest'
            },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median response time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesResponseTimeVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotResponseTimeVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewResponseTimeVsRequest"), dataset, prepareOverviewOptions(options));

    }
};

// Response Time vs Request
function refreshResponseTimeVsRequest() {
    var infos = responseTimeVsRequestInfos;
    prepareSeries(infos.data);
    if (isGraph($("#flotResponseTimeVsRequest"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeVsRequest");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimeVsRequest", "#overviewResponseTimeVsRequest");
        $('#footerResponseRimeVsRequest .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var latenciesVsRequestInfos = {
    data: {"result": {"minY": 7.0, "minX": 1.0, "maxY": 47484.0, "series": [{"data": [[2.0, 37330.5], [3.0, 13639.0], [5.0, 28092.5], [7.0, 44040.0], [8.0, 43884.0], [9.0, 36043.0], [10.0, 42240.5], [12.0, 27919.0], [14.0, 23562.5], [17.0, 22701.0], [18.0, 7514.5], [19.0, 748.0], [20.0, 47484.0], [22.0, 5664.0], [23.0, 4382.5], [24.0, 14864.0], [25.0, 22038.0], [26.0, 18755.5], [27.0, 19558.5], [28.0, 12698.5], [29.0, 6966.0], [30.0, 13096.5], [31.0, 11404.0], [32.0, 16750.0], [33.0, 17471.0], [34.0, 5580.5], [35.0, 12293.0], [36.0, 9325.5], [37.0, 32088.0], [39.0, 12550.0], [38.0, 28764.5], [41.0, 9255.0], [40.0, 15511.0], [42.0, 30669.0], [43.0, 30647.0], [45.0, 28604.0], [47.0, 21330.0], [48.0, 14835.0], [49.0, 17086.5], [51.0, 11712.0], [50.0, 10451.5], [52.0, 31808.5], [55.0, 30398.0], [56.0, 25583.0], [57.0, 473.0], [61.0, 1297.5], [60.0, 1635.5], [63.0, 3030.0], [62.0, 9057.5], [65.0, 15706.0], [67.0, 3193.0], [64.0, 3081.0], [66.0, 12208.0], [69.0, 29712.0], [68.0, 729.0], [71.0, 7224.0], [70.0, 8568.5], [73.0, 3823.0], [74.0, 8876.5], [75.0, 8492.0], [72.0, 4075.0], [78.0, 2175.0], [79.0, 1762.0], [76.0, 2179.5], [80.0, 1798.0], [82.0, 6007.5], [81.0, 712.0], [83.0, 2506.0], [84.0, 6407.5], [87.0, 2879.5], [86.0, 9678.5], [88.0, 10741.5], [90.0, 4972.0], [89.0, 6299.5], [91.0, 9974.0], [92.0, 7293.5], [94.0, 7227.0], [95.0, 5140.0], [93.0, 7103.5], [99.0, 8570.0], [98.0, 8289.0], [97.0, 4743.0], [96.0, 6253.0], [102.0, 10133.5], [103.0, 6650.0], [100.0, 10309.5], [101.0, 9532.5], [104.0, 5956.0], [105.0, 5400.5], [106.0, 9671.5], [107.0, 9729.0], [111.0, 6286.5], [110.0, 9848.5], [109.0, 7878.0], [112.0, 6664.0], [115.0, 9671.0], [114.0, 9035.5], [116.0, 9671.5], [118.0, 2427.5], [119.0, 6680.0], [117.0, 7733.0], [123.0, 9030.0], [120.0, 6937.0], [121.0, 10527.0], [124.0, 6511.5], [127.0, 11130.0], [131.0, 3470.0], [128.0, 7948.0], [133.0, 8925.0], [134.0, 2001.0], [135.0, 8173.5], [132.0, 9198.0], [142.0, 6097.5], [140.0, 8861.0], [137.0, 11467.0], [141.0, 7150.0], [138.0, 7949.5], [136.0, 8322.0], [143.0, 7860.0], [147.0, 6804.0], [149.0, 490.0], [148.0, 4085.0], [145.0, 7866.0], [146.0, 10790.0], [156.0, 7708.5], [159.0, 7604.5], [152.0, 10644.5], [153.0, 11394.0], [165.0, 11557.0], [163.0, 7705.0], [172.0, 6256.5], [185.0, 11069.0], [199.0, 9540.0], [212.0, 4972.5], [217.0, 4529.0], [232.0, 2131.0], [245.0, 5591.0], [293.0, 6831.0], [1.0, 33245.5]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[49.0, 7.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 293.0, "title": "Latencies Vs Request"}},
    getOptions: function() {
        return{
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Latency in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: { noColumns: 2,show: true, container: '#legendLatencyVsRequest' },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median Latency time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesLatencyVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotLatenciesVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewLatenciesVsRequest"), dataset, prepareOverviewOptions(options));
    }
};

// Latencies vs Request
function refreshLatenciesVsRequest() {
        var infos = latenciesVsRequestInfos;
        prepareSeries(infos.data);
        if(isGraph($("#flotLatenciesVsRequest"))){
            infos.createGraph();
        }else{
            var choiceContainer = $("#choicesLatencyVsRequest");
            createLegend(choiceContainer, infos);
            infos.createGraph();
            setGraphZoomable("#flotLatenciesVsRequest", "#overviewLatenciesVsRequest");
            $('#footerLatenciesVsRequest .legendColorBox > div').each(function(i){
                $(this).clone().prependTo(choiceContainer.find("li").eq(i));
            });
        }
};

var hitsPerSecondInfos = {
        data: {"result": {"minY": 22.333333333333332, "minX": 1.698213E12, "maxY": 108.98333333333333, "series": [{"data": [[1.69821324E12, 108.98333333333333], [1.69821306E12, 22.333333333333332], [1.69821336E12, 63.93333333333333], [1.69821318E12, 44.916666666666664], [1.698213E12, 31.116666666666667], [1.6982133E12, 66.15], [1.69821312E12, 87.06666666666666]], "isOverall": false, "label": "hitsPerSecond", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821336E12, "title": "Hits Per Second"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of hits / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendHitsPerSecond"
                },
                selection: {
                    mode : 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y.2 hits/sec"
                }
            };
        },
        createGraph: function createGraph() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesHitsPerSecond"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotHitsPerSecond"), dataset, options);
            // setup overview
            $.plot($("#overviewHitsPerSecond"), dataset, prepareOverviewOptions(options));
        }
};

// Hits per second
function refreshHitsPerSecond(fixTimestamps) {
    var infos = hitsPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if (isGraph($("#flotHitsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesHitsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotHitsPerSecond", "#overviewHitsPerSecond");
        $('#footerHitsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var codesPerSecondInfos = {
        data: {"result": {"minY": 0.016666666666666666, "minX": 1.698213E12, "maxY": 108.76666666666667, "series": [{"data": [[1.69821324E12, 108.76666666666667], [1.69821306E12, 38.983333333333334], [1.69821336E12, 80.58333333333333], [1.69821318E12, 55.1], [1.698213E12, 14.45], [1.6982133E12, 56.2], [1.69821312E12, 70.4]], "isOverall": false, "label": "200", "isController": false}, {"data": [[1.69821306E12, 0.016666666666666666]], "isOverall": false, "label": "502", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821336E12, "title": "Codes Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendCodesPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "Number of Response Codes %s at %x was %y.2 responses / sec"
                }
            };
        },
    createGraph: function() {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesCodesPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotCodesPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewCodesPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Codes per second
function refreshCodesPerSecond(fixTimestamps) {
    var infos = codesPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotCodesPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesCodesPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotCodesPerSecond", "#overviewCodesPerSecond");
        $('#footerCodesPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var transactionsPerSecondInfos = {
        data: {"result": {"minY": 0.016666666666666666, "minX": 1.698213E12, "maxY": 108.76666666666667, "series": [{"data": [[1.69821324E12, 108.76666666666667], [1.69821306E12, 38.983333333333334], [1.69821336E12, 80.58333333333333], [1.69821318E12, 55.1], [1.698213E12, 14.45], [1.6982133E12, 56.2], [1.69821312E12, 70.4]], "isOverall": false, "label": "HTTP Request-success", "isController": false}, {"data": [[1.69821306E12, 0.016666666666666666]], "isOverall": false, "label": "HTTP Request-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821336E12, "title": "Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTransactionsPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                }
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTransactionsPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTransactionsPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewTransactionsPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Transactions per second
function refreshTransactionsPerSecond(fixTimestamps) {
    var infos = transactionsPerSecondInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTransactionsPerSecond");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTransactionsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTransactionsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTransactionsPerSecond", "#overviewTransactionsPerSecond");
        $('#footerTransactionsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var totalTPSInfos = {
        data: {"result": {"minY": 0.016666666666666666, "minX": 1.698213E12, "maxY": 108.76666666666667, "series": [{"data": [[1.69821324E12, 108.76666666666667], [1.69821306E12, 38.983333333333334], [1.69821336E12, 80.58333333333333], [1.69821318E12, 55.1], [1.698213E12, 14.45], [1.6982133E12, 56.2], [1.69821312E12, 70.4]], "isOverall": false, "label": "Transaction-success", "isController": false}, {"data": [[1.69821306E12, 0.016666666666666666]], "isOverall": false, "label": "Transaction-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821336E12, "title": "Total Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTotalTPS"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                },
                colors: ["#9ACD32", "#FF6347"]
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTotalTPS"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTotalTPS"), dataset, options);
        // setup overview
        $.plot($("#overviewTotalTPS"), dataset, prepareOverviewOptions(options));
    }
};

// Total Transactions per second
function refreshTotalTPS(fixTimestamps) {
    var infos = totalTPSInfos;
    // We want to ignore seriesFilter
    prepareSeries(infos.data, false, true);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTotalTPS"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTotalTPS");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTotalTPS", "#overviewTotalTPS");
        $('#footerTotalTPS .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

// Collapse the graph matching the specified DOM element depending the collapsed
// status
function collapse(elem, collapsed){
    if(collapsed){
        $(elem).parent().find(".fa-chevron-up").removeClass("fa-chevron-up").addClass("fa-chevron-down");
    } else {
        $(elem).parent().find(".fa-chevron-down").removeClass("fa-chevron-down").addClass("fa-chevron-up");
        if (elem.id == "bodyBytesThroughputOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshBytesThroughputOverTime(true);
            }
            document.location.href="#bytesThroughputOverTime";
        } else if (elem.id == "bodyLatenciesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesOverTime(true);
            }
            document.location.href="#latenciesOverTime";
        } else if (elem.id == "bodyCustomGraph") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCustomGraph(true);
            }
            document.location.href="#responseCustomGraph";
        } else if (elem.id == "bodyConnectTimeOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshConnectTimeOverTime(true);
            }
            document.location.href="#connectTimeOverTime";
        } else if (elem.id == "bodyResponseTimePercentilesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimePercentilesOverTime(true);
            }
            document.location.href="#responseTimePercentilesOverTime";
        } else if (elem.id == "bodyResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeDistribution();
            }
            document.location.href="#responseTimeDistribution" ;
        } else if (elem.id == "bodySyntheticResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshSyntheticResponseTimeDistribution();
            }
            document.location.href="#syntheticResponseTimeDistribution" ;
        } else if (elem.id == "bodyActiveThreadsOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshActiveThreadsOverTime(true);
            }
            document.location.href="#activeThreadsOverTime";
        } else if (elem.id == "bodyTimeVsThreads") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTimeVsThreads();
            }
            document.location.href="#timeVsThreads" ;
        } else if (elem.id == "bodyCodesPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCodesPerSecond(true);
            }
            document.location.href="#codesPerSecond";
        } else if (elem.id == "bodyTransactionsPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTransactionsPerSecond(true);
            }
            document.location.href="#transactionsPerSecond";
        } else if (elem.id == "bodyTotalTPS") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTotalTPS(true);
            }
            document.location.href="#totalTPS";
        } else if (elem.id == "bodyResponseTimeVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeVsRequest();
            }
            document.location.href="#responseTimeVsRequest";
        } else if (elem.id == "bodyLatenciesVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesVsRequest();
            }
            document.location.href="#latencyVsRequest";
        }
    }
}

/*
 * Activates or deactivates all series of the specified graph (represented by id parameter)
 * depending on checked argument.
 */
function toggleAll(id, checked){
    var placeholder = document.getElementById(id);

    var cases = $(placeholder).find(':checkbox');
    cases.prop('checked', checked);
    $(cases).parent().children().children().toggleClass("legend-disabled", !checked);

    var choiceContainer;
    if ( id == "choicesBytesThroughputOverTime"){
        choiceContainer = $("#choicesBytesThroughputOverTime");
        refreshBytesThroughputOverTime(false);
    } else if(id == "choicesResponseTimesOverTime"){
        choiceContainer = $("#choicesResponseTimesOverTime");
        refreshResponseTimeOverTime(false);
    }else if(id == "choicesResponseCustomGraph"){
        choiceContainer = $("#choicesResponseCustomGraph");
        refreshCustomGraph(false);
    } else if ( id == "choicesLatenciesOverTime"){
        choiceContainer = $("#choicesLatenciesOverTime");
        refreshLatenciesOverTime(false);
    } else if ( id == "choicesConnectTimeOverTime"){
        choiceContainer = $("#choicesConnectTimeOverTime");
        refreshConnectTimeOverTime(false);
    } else if ( id == "choicesResponseTimePercentilesOverTime"){
        choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        refreshResponseTimePercentilesOverTime(false);
    } else if ( id == "choicesResponseTimePercentiles"){
        choiceContainer = $("#choicesResponseTimePercentiles");
        refreshResponseTimePercentiles();
    } else if(id == "choicesActiveThreadsOverTime"){
        choiceContainer = $("#choicesActiveThreadsOverTime");
        refreshActiveThreadsOverTime(false);
    } else if ( id == "choicesTimeVsThreads"){
        choiceContainer = $("#choicesTimeVsThreads");
        refreshTimeVsThreads();
    } else if ( id == "choicesSyntheticResponseTimeDistribution"){
        choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        refreshSyntheticResponseTimeDistribution();
    } else if ( id == "choicesResponseTimeDistribution"){
        choiceContainer = $("#choicesResponseTimeDistribution");
        refreshResponseTimeDistribution();
    } else if ( id == "choicesHitsPerSecond"){
        choiceContainer = $("#choicesHitsPerSecond");
        refreshHitsPerSecond(false);
    } else if(id == "choicesCodesPerSecond"){
        choiceContainer = $("#choicesCodesPerSecond");
        refreshCodesPerSecond(false);
    } else if ( id == "choicesTransactionsPerSecond"){
        choiceContainer = $("#choicesTransactionsPerSecond");
        refreshTransactionsPerSecond(false);
    } else if ( id == "choicesTotalTPS"){
        choiceContainer = $("#choicesTotalTPS");
        refreshTotalTPS(false);
    } else if ( id == "choicesResponseTimeVsRequest"){
        choiceContainer = $("#choicesResponseTimeVsRequest");
        refreshResponseTimeVsRequest();
    } else if ( id == "choicesLatencyVsRequest"){
        choiceContainer = $("#choicesLatencyVsRequest");
        refreshLatenciesVsRequest();
    }
    var color = checked ? "black" : "#818181";
    if(choiceContainer != null) {
        choiceContainer.find("label").each(function(){
            this.style.color = color;
        });
    }
}

